/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.modules.progress.spi.ProgressEnvironment;
import org.netbeans.modules.progress.spi.ProgressEvent;
import org.netbeans.modules.progress.spi.ProgressUIWorker;
import org.netbeans.modules.progress.spi.ProgressUIWorkerWithModel;
import org.netbeans.modules.progress.spi.TaskModel;
import org.netbeans.progress.module.DefaultHandleFactory;
import org.netbeans.progress.module.TrivialProgressBaseWorkerProvider;
import org.openide.util.RequestProcessor;

public class Controller {
    private static final Logger LOG = Logger.getLogger(Controller.class.getName());
    public static Controller defaultInstance;
    private ProgressUIWorker component;
    private TaskModel model;
    private List<ProgressEvent> eventQueue;
    private boolean dispatchRunning;
    private long timerStart = 0L;
    private static final int TIMER_QUANTUM = 400;
    public static final int INITIAL_DELAY = 500;
    private int taskDelay = 400;
    private static final RequestProcessor RQ;
    private final RequestProcessor.Task task = RQ.create(new Runnable(){

        @Override
        public void run() {
            Controller.this.runEvents();
        }
    });

    public Controller(ProgressUIWorker progressUIWorker) {
        this.component = progressUIWorker;
        this.model = new TaskModel(this.getEventExecutor());
        this.eventQueue = new LinkedList<ProgressEvent>();
        this.dispatchRunning = false;
    }

    public static synchronized Controller getDefault() {
        if (defaultInstance == null) {
            ProgressEnvironment progressEnvironment = DefaultHandleFactory.get();
            defaultInstance = progressEnvironment.getController();
        }
        return defaultInstance;
    }

    protected ProgressUIWorkerWithModel createWorker() {
        Logger.getLogger(Controller.class.getName()).log(Level.CONFIG, "Using fallback trivial progress implementation");
        return new TrivialProgressBaseWorkerProvider().getDefaultWorker();
    }

    protected final ProgressUIWorker getProgressUIWorker() {
        if (this.component == null) {
            ProgressUIWorkerWithModel progressUIWorkerWithModel = this.createWorker();
            progressUIWorkerWithModel.setModel(Controller.getDefault().getModel());
            this.component = progressUIWorkerWithModel;
        }
        return this.component;
    }

    public TaskModel getModel() {
        return this.model;
    }

    void start(InternalHandle internalHandle) {
        ProgressEvent progressEvent = new ProgressEvent(internalHandle, 0, this.isWatched(internalHandle));
        if (this == Controller.getDefault() && internalHandle.getInitialDelay() > 100) {
            this.postEvent(progressEvent, true);
        } else {
            this.runImmediately(Collections.singleton(progressEvent));
        }
    }

    void finish(InternalHandle internalHandle) {
        ProgressEvent progressEvent = new ProgressEvent(internalHandle, 4, this.isWatched(internalHandle));
        this.postEvent(progressEvent);
    }

    void toIndeterminate(InternalHandle internalHandle) {
        ProgressEvent progressEvent = new ProgressEvent(internalHandle, 5, this.isWatched(internalHandle));
        this.model.updateSelection();
        this.postEvent(progressEvent);
    }

    void toSilent(InternalHandle internalHandle, String string) {
        ProgressEvent progressEvent = new ProgressEvent(internalHandle, 6, this.isWatched(internalHandle), string);
        this.model.updateSelection();
        this.postEvent(progressEvent);
    }

    void toDeterminate(InternalHandle internalHandle) {
        ProgressEvent progressEvent = new ProgressEvent(internalHandle, 5, this.isWatched(internalHandle));
        this.model.updateSelection();
        this.postEvent(progressEvent);
    }

    void progress(InternalHandle internalHandle, String string, int n, double d, long l) {
        ProgressEvent progressEvent = new ProgressEvent(internalHandle, string, n, d, l, this.isWatched(internalHandle));
        this.postEvent(progressEvent);
    }

    ProgressEvent snapshot(InternalHandle internalHandle, String string, int n, double d, long l) {
        if (internalHandle.isInSleepMode()) {
            return new ProgressEvent(internalHandle, 6, this.isWatched(internalHandle), string);
        }
        return new ProgressEvent(internalHandle, string, n, d, l, this.isWatched(internalHandle));
    }

    void explicitSelection(InternalHandle internalHandle) {
        InternalHandle internalHandle2 = this.model.getExplicitSelection();
        this.model.explicitlySelect(internalHandle);
        ArrayList<ProgressEvent> arrayList = new ArrayList<ProgressEvent>();
        arrayList.add(internalHandle.requestStateSnapshot());
        if (internalHandle2 != null && internalHandle2 != internalHandle) {
            arrayList.add(internalHandle2.requestStateSnapshot());
        }
        this.runImmediately(arrayList);
    }

    void displayNameChange(InternalHandle internalHandle, int n, double d, long l, String string) {
        ArrayList<ProgressEvent> arrayList = new ArrayList<ProgressEvent>();
        arrayList.add(new ProgressEvent(internalHandle, null, n, d, l, this.isWatched(internalHandle), string));
        this.runImmediately(arrayList);
    }

    private boolean isWatched(InternalHandle internalHandle) {
        return this.model.getExplicitSelection() == internalHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runImmediately(Collection<ProgressEvent> collection) {
        Controller controller = this;
        synchronized (controller) {
            this.eventQueue.addAll(collection);
            this.dispatchRunning = true;
        }
        this.runEvents();
    }

    void postEvent(ProgressEvent progressEvent) {
        this.postEvent(progressEvent, false);
    }

    final void schedule(int n, boolean bl, boolean bl2) {
        if (n != -1) {
            if (bl && this.taskDelay < n) {
                n = this.taskDelay;
            }
        } else {
            n = this.taskDelay;
        }
        this.taskDelay = n;
        this.resetTimer(n, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postEvent(ProgressEvent progressEvent, boolean bl) {
        Controller controller = this;
        synchronized (controller) {
            this.eventQueue.add(progressEvent);
            if (!this.dispatchRunning) {
                this.timerStart = System.currentTimeMillis();
                this.dispatchRunning = true;
                this.schedule(bl ? progressEvent.getSource().getInitialDelay() : -1, bl, true);
            } else if (bl && System.currentTimeMillis() - this.timerStart > (long)progressEvent.getSource().getInitialDelay()) {
                this.schedule(progressEvent.getSource().getInitialDelay(), false, true);
            }
        }
    }

    protected void resetTimer(int n, boolean bl) {
        if (n > 0) {
            if (bl) {
                this.task.schedule(n);
            }
        } else {
            assert (bl);
            this.task.cancel();
        }
    }

    protected Executor getEventExecutor() {
        return RQ;
    }

    protected void runEvents() {
        RQ.execute(new Runnable(){

            @Override
            public void run() {
                Controller.this.runNow();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNow() {
        Object object;
        Iterator<ProgressEvent> iterator;
        HashMap<InternalHandle, Object> hashMap = new HashMap<InternalHandle, Object>();
        boolean bl = false;
        long l = 400L;
        InternalHandle internalHandle = this.model.getSelectedHandle();
        long l2 = System.currentTimeMillis();
        Object object2 = this;
        synchronized (object2) {
            Object object3;
            iterator = this.eventQueue.iterator();
            object = new ArrayList();
            while (iterator.hasNext()) {
                boolean bl2;
                object3 = iterator.next();
                boolean bl3 = bl2 = l2 - ((ProgressEvent)object3).getSource().getTimeStampStarted() < (long)((ProgressEvent)object3).getSource().getInitialDelay();
                if (((ProgressEvent)object3).getType() == 0) {
                    if (((ProgressEvent)object3).getSource().isCustomPlaced() || !bl2) {
                        LOG.log(Level.FINER, "Adding to model {0}", object3);
                        this.model.addHandle(((ProgressEvent)object3).getSource());
                    } else {
                        LOG.log(Level.FINER, "Short-start: {0}", object3);
                        object.add(((ProgressEvent)object3).getSource());
                    }
                } else if (((ProgressEvent)object3).getType() == 4 && !object.contains(((ProgressEvent)object3).getSource())) {
                    LOG.log(Level.FINER, "Removed from model: {0}", object3);
                    this.model.removeHandle(((ProgressEvent)object3).getSource());
                }
                ProgressEvent progressEvent = (ProgressEvent)hashMap.get(((ProgressEvent)object3).getSource());
                if (progressEvent != null && ((ProgressEvent)object3).getType() == 4 && object.contains(((ProgressEvent)object3).getSource()) && bl2) {
                    LOG.log(Level.FINER, "Short task ended: {0}", object3);
                    hashMap.remove(((ProgressEvent)object3).getSource());
                    object.remove(((ProgressEvent)object3).getSource());
                } else {
                    if (progressEvent != null) {
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.log(Level.FINE, "Merging event " + ((ProgressEvent)object3).toString());
                        }
                        ((ProgressEvent)object3).copyMessageFromEarlier(progressEvent);
                        if (progressEvent.isSwitched()) {
                            ((ProgressEvent)object3).markAsSwitched();
                        }
                        if (progressEvent.getType() == 4) {
                            ((ProgressEvent)object3).markAsFinished();
                        }
                        LOG.log(Level.FINER, "Event merged with {0} to {1}", new Object[]{progressEvent, object3});
                    }
                    hashMap.put(((ProgressEvent)object3).getSource(), object3);
                }
                iterator.remove();
            }
            object3 = object.iterator();
            while (object3.hasNext()) {
                InternalHandle internalHandle2 = (InternalHandle)object3.next();
                long l3 = l2 - internalHandle2.getTimeStampStarted();
                if (l3 >= (long)internalHandle2.getInitialDelay()) {
                    this.model.addHandle(internalHandle2);
                    continue;
                }
                ProgressEvent progressEvent = new ProgressEvent(internalHandle2, 0, this.isWatched(internalHandle2));
                this.eventQueue.add(progressEvent);
                LOG.log(Level.FINER, "Repost start event: {0}", progressEvent);
                ProgressEvent progressEvent2 = (ProgressEvent)hashMap.remove(internalHandle2);
                if (progressEvent2.getType() != 0) {
                    LOG.log(Level.FINER, "Repost queued event: {0}", progressEvent2);
                    this.eventQueue.add(progressEvent2);
                }
                bl = true;
                l = Math.min(l, (long)internalHandle2.getInitialDelay() - l3);
            }
        }
        object2 = this.model.getSelectedHandle();
        object2 = object2 == null ? internalHandle : object2;
        iterator = hashMap.values().iterator();
        if (this.component == null) {
            this.getProgressUIWorker();
        }
        while (iterator.hasNext()) {
            object = iterator.next();
            LOG.log(Level.FINER, "Dispatching: {0}", object);
            if (object2 == ((ProgressEvent)object).getSource()) {
                this.component.processSelectedProgressEvent((ProgressEvent)object);
            }
            this.component.processProgressEvent((ProgressEvent)object);
        }
        object = this;
        synchronized (object) {
            this.schedule(0, false, true);
            if (bl) {
                this.timerStart = System.currentTimeMillis();
                this.schedule((int)Math.max(100L, l), false, true);
            } else {
                this.dispatchRunning = false;
                this.schedule(400, false, !this.eventQueue.isEmpty());
            }
        }
    }

    static {
        RQ = new RequestProcessor(Controller.class.getName());
    }
}

