/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumFormatAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumLetterSyncAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextFixedAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextPageAdjustAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextSelectPageAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextPageNumberElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "page-number");

    public TextPageNumberElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getStyleNumFormatAttribute() {
        StyleNumFormatAttribute attr = (StyleNumFormatAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "num-format");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setStyleNumFormatAttribute(String styleNumFormatValue) {
        StyleNumFormatAttribute attr = new StyleNumFormatAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(styleNumFormatValue);
    }

    public Boolean getStyleNumLetterSyncAttribute() {
        StyleNumLetterSyncAttribute attr = (StyleNumLetterSyncAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "num-letter-sync");
        if (attr != null) {
            return attr.booleanValue();
        }
        return null;
    }

    public void setStyleNumLetterSyncAttribute(Boolean styleNumLetterSyncValue) {
        StyleNumLetterSyncAttribute attr = new StyleNumLetterSyncAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(styleNumLetterSyncValue);
    }

    public Boolean getTextFixedAttribute() {
        TextFixedAttribute attr = (TextFixedAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "fixed");
        if (attr != null) {
            return attr.booleanValue();
        }
        return null;
    }

    public void setTextFixedAttribute(Boolean textFixedValue) {
        TextFixedAttribute attr = new TextFixedAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(textFixedValue);
    }

    public Integer getTextPageAdjustAttribute() {
        TextPageAdjustAttribute attr = (TextPageAdjustAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "page-adjust");
        if (attr != null) {
            return attr.intValue();
        }
        return null;
    }

    public void setTextPageAdjustAttribute(Integer textPageAdjustValue) {
        TextPageAdjustAttribute attr = new TextPageAdjustAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setIntValue(textPageAdjustValue);
    }

    public String getTextSelectPageAttribute() {
        TextSelectPageAttribute attr = (TextSelectPageAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "select-page");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextSelectPageAttribute(String textSelectPageValue) {
        TextSelectPageAttribute attr = new TextSelectPageAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textSelectPageValue);
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    public void newTextNode(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
    }
}

