/*
 * Copyright (C) 2025 The Phosh.mobi e.V.
 *
 * SPDX-License-Identifier: GPL-3.0+
 *
 * Author: Evangelos Ribeiro Tzaras <devrtz@fortysixandtwo.eu>
 */

#pragma once

#include "cbd-channel-manager.h"
#include "cbd-message.h"
#include "lcb-dbus.h"

#include <glib-object.h>

G_BEGIN_DECLS


#define CBD_TYPE_MANAGER (cbd_manager_get_type ())

G_DECLARE_FINAL_TYPE (CbdManager, cbd_manager, CBD, MANAGER, LcbDBusCbdSkeleton);

CbdManager *cbd_manager_new                     (void);
gboolean    cbd_manager_add_message             (CbdManager *self,
                                                 CbdMessage *message);

G_END_DECLS
