declare id "tiltdrive";
declare name "Tilt Tone Pro";
declare category "External";

import("stdfaust.lib");


p1 = pre : fi.iir((b0/a0,b1/a0,b2/a0,b3/a0,b4/a0),(a1/a0,a2/a0,a3/a0,a4/a0)) : tiltdrivepro_inclip with {
    LogPot(a, x) = ba.if(a, (exp(a * x) - 1) / (exp(a) - 1), x);
    Inverted(b, x) = ba.if(b, 1 - x, x);
    s = 0.993;
    fs = float(ma.SR);
    pre = _;



    Body = vslider("Body[name:Body]", 0.5, 0, 1, 0.01) : Inverted(0) : si.smooth(s);

    Tone = vslider("Tone[name:Tone]", 0.5, 0, 1, 0.01) : Inverted(0) : LogPot(1) : si.smooth(s);

    Drive = vslider("Drive[name:Drive]", 0.5, 0, 1, 0.01) : Inverted(1) : LogPot(1) : si.smooth(s);

    b0 = Body*(Drive*fs*(fs*(7.4702418575578e-15*fs + 1.59088484003545e-12) + 5.76407550737481e-11) + Tone*(Drive*pow(fs,2)*(fs*(3.65730590942934e-18*fs + 6.09550984904878e-16) - 9.63708565903573e-28) + pow(fs,2)*(fs*(-3.65730590942934e-18*fs - 6.09550984904878e-16) + 9.63708565903573e-28)) + fs*(fs*(-7.4702418575578e-15*fs - 1.59088484003545e-12) - 5.76407550737481e-11)) + Drive*fs*(fs*(9.8607192519763e-16*fs + 3.66844210330959e-12) + 5.84016130407215e-10) + Tone*(Drive*fs*(fs*(fs*(4.82764380044673e-19*fs + 8.0460730007444e-17) - 3.45844530442491e-12) - 5.7640755073748e-10) + fs*(fs*(fs*(-4.82764380044673e-19*fs - 8.0460730007444e-17) + 3.45844530442491e-12) + 5.7640755073748e-10)) + fs*(fs*(-9.8607192519763e-16*fs - 3.66844210330959e-12) - 5.84016130407215e-10);

    b1 = Body*(Drive*fs*(-1.49404837151156e-14*pow(fs,2) + 1.15281510147496e-10) + Tone*(Drive*pow(fs,3)*(-1.46292236377174e-17*fs - 1.21910196980976e-15) + pow(fs,3)*(1.46292236377174e-17*fs + 1.21910196980976e-15)) + fs*(1.49404837151156e-14*pow(fs,2) - 1.15281510147496e-10)) + Drive*fs*(-1.97214385039526e-15*pow(fs,2) + 1.16803226081443e-9) + Tone*(Drive*fs*(pow(fs,2)*(-1.93105752017869e-18*fs - 1.60921460014888e-16) - 1.15281510147496e-9) + fs*(pow(fs,2)*(1.93105752017869e-18*fs + 1.60921460014888e-16) + 1.15281510147496e-9)) + fs*(1.97214385039526e-15*pow(fs,2) - 1.16803226081443e-9);

    b2 = Body*(-3.18176968007089e-12*Drive*pow(fs,2) + Tone*(Drive*pow(fs,2)*(2.1943835456576e-17*pow(fs,2) + 1.92741713180715e-27) + pow(fs,2)*(-2.1943835456576e-17*pow(fs,2) - 1.92741713180715e-27)) + 3.18176968007089e-12*pow(fs,2)) - 7.33688420661919e-12*Drive*pow(fs,2) + Tone*(Drive*pow(fs,2)*(2.89658628026804e-18*pow(fs,2) + 6.91689060884983e-12) + pow(fs,2)*(-2.89658628026804e-18*pow(fs,2) - 6.91689060884983e-12)) + 7.33688420661919e-12*pow(fs,2);

    b3 = Body*(Drive*fs*(1.49404837151156e-14*pow(fs,2) - 1.15281510147496e-10) + Tone*(Drive*pow(fs,3)*(-1.46292236377174e-17*fs + 1.21910196980976e-15) + pow(fs,3)*(1.46292236377174e-17*fs - 1.21910196980976e-15)) + fs*(-1.49404837151156e-14*pow(fs,2) + 1.15281510147496e-10)) + Drive*fs*(1.97214385039526e-15*pow(fs,2) - 1.16803226081443e-9) + Tone*(Drive*fs*(pow(fs,2)*(-1.93105752017869e-18*fs + 1.60921460014888e-16) + 1.15281510147496e-9) + fs*(pow(fs,2)*(1.93105752017869e-18*fs - 1.60921460014888e-16) - 1.15281510147496e-9)) + fs*(-1.97214385039526e-15*pow(fs,2) + 1.16803226081443e-9);

    b4 = Body*(Drive*fs*(fs*(-7.4702418575578e-15*fs + 1.59088484003545e-12) - 5.76407550737481e-11) + Tone*(Drive*pow(fs,2)*(fs*(3.65730590942934e-18*fs - 6.09550984904878e-16) - 9.63708565903573e-28) + pow(fs,2)*(fs*(-3.65730590942934e-18*fs + 6.09550984904878e-16) + 9.63708565903573e-28)) + fs*(fs*(7.4702418575578e-15*fs - 1.59088484003545e-12) + 5.76407550737481e-11)) + Drive*fs*(fs*(-9.8607192519763e-16*fs + 3.66844210330959e-12) - 5.84016130407215e-10) + Tone*(Drive*fs*(fs*(fs*(4.82764380044673e-19*fs - 8.0460730007444e-17) - 3.45844530442491e-12) + 5.7640755073748e-10) + fs*(fs*(fs*(-4.82764380044673e-19*fs + 8.0460730007444e-17) + 3.45844530442491e-12) - 5.7640755073748e-10)) + fs*(fs*(9.8607192519763e-16*fs - 3.66844210330959e-12) + 5.84016130407215e-10);

    a0 = Body*(Drive*(Drive*(fs*(fs*(fs*(-7.30862585054866e-20*fs - 1.67322263662277e-16) - 5.1124129373811e-14) - 1.94898394972096e-12) + 1.96683234297117e-25) + fs*(fs*(fs*(7.30862585054866e-20*fs + 1.42960177493781e-16) + 3.6417513972127e-14) - 5.41394578846342e-14) - 4.14677436110847e-11) + Tone*(Drive*(fs*(fs*(fs*(-1.82715646263716e-20*fs - 1.61866577328053e-18) + 8.22617247056166e-17) - 4.8724598743024e-13) + 4.91708085742792e-26) + Tone*(Drive*fs*(fs*(fs*(1.61878313287101e-20*fs + 1.69238926121966e-17) + 3.65434490572681e-15) - 3.68781064307094e-28) + fs*(fs*(fs*(-3.23756626574203e-20*fs - 3.38477852243932e-17) - 7.30868981145362e-15) + 7.37562128614188e-28)) + fs*(fs*(fs*(3.65431292527433e-20*fs + 3.23733154656106e-18) - 1.64523449411233e-16) + 9.7449197486048e-13) - 9.83416171485584e-26) + fs*(fs*(fs*(7.30862585054866e-20*fs + 2.16046435999268e-16) + 8.0537360177179e-14) + 5.95523076493215e-12) + 8.29354872221687e-11) + Drive*(Drive*(fs*(fs*(fs*(-9.29967180291844e-20*fs - 3.84360911986598e-16) - 4.45548735927406e-13) - 9.98720416827966e-11) - 1.65870974444338e-9) + fs*(fs*(fs*(9.29967180291844e-20*fs + 3.5336200597687e-16) + 3.79597819598007e-13) + 8.2686476087768e-11) + 1.23855856617587e-9) + Tone*(Drive*(fs*(fs*(fs*(-2.32491795072961e-20*fs - 3.52160359068941e-17) + 1.83300570278997e-14) + 8.87429618975008e-12) + 4.14677436110845e-10) + Tone*(Drive*(fs*(fs*(fs*(2.29741267120048e-20*fs + 6.50194364851177e-17) + 4.61728181436945e-14) + 7.98254064513374e-12) - 4.91708085742792e-25) + fs*(fs*(fs*(-4.59482534240096e-20*fs - 1.30038872970235e-16) - 9.23456362873891e-14) - 1.59650812902675e-11) + 9.83416171485584e-25) + fs*(fs*(fs*(4.64983590145922e-20*fs + 7.04320718137881e-17) - 3.66601140557995e-14) - 1.77485923795002e-11) - 8.2935487222169e-10) + fs*(fs*(fs*(9.29967180291844e-20*fs + 4.46358724006055e-16) + 5.77450568586205e-13) + 1.34243172872854e-10) + 2.49901210097839e-9;

    a1 = Body*(Drive*(Drive*(fs*(pow(fs,2)*(2.92345034021946e-19*fs + 3.34644527324554e-16) - 3.89796789944192e-12) + 7.86732937188467e-25) + fs*(pow(fs,2)*(-2.92345034021946e-19*fs - 2.85920354987563e-16) - 1.08278915769268e-13) - 1.65870974444339e-10) + Tone*(Drive*(fs*(pow(fs,2)*(7.30862585054866e-20*fs + 3.23733154656106e-18) - 9.7449197486048e-13) + 1.96683234297117e-25) + Tone*(Drive*fs*(pow(fs,2)*(-6.47513253148406e-20*fs - 3.38477852243932e-17) - 7.37562128614188e-28) + fs*(pow(fs,2)*(1.29502650629681e-19*fs + 6.76955704487864e-17) + 1.47512425722838e-27)) + fs*(pow(fs,2)*(-1.46172517010973e-19*fs - 6.47466309312212e-18) + 1.94898394972096e-12) - 3.93366468594234e-25) + fs*(pow(fs,2)*(-2.92345034021946e-19*fs - 4.32092871998536e-16) + 1.19104615298643e-11) + 3.31741948888675e-10) + Drive*(Drive*(fs*(pow(fs,2)*(3.71986872116738e-19*fs + 7.68721823973197e-16) - 1.99744083365593e-10) - 6.63483897777351e-9) + fs*(pow(fs,2)*(-3.71986872116738e-19*fs - 7.06724011953741e-16) + 1.65372952175536e-10) + 4.95423426470347e-9) + Tone*(Drive*(fs*(pow(fs,2)*(9.29967180291844e-20*fs + 7.04320718137881e-17) + 1.77485923795002e-11) + 1.65870974444338e-9) + Tone*(Drive*(fs*(pow(fs,2)*(-9.18965068480191e-20*fs - 1.30038872970235e-16) + 1.59650812902675e-11) - 1.96683234297117e-24) + fs*(pow(fs,2)*(1.83793013696038e-19*fs + 2.60077745940471e-16) - 3.1930162580535e-11) + 3.93366468594234e-24) + fs*(pow(fs,2)*(-1.85993436058369e-19*fs - 1.40864143627576e-16) - 3.54971847590003e-11) - 3.31741948888676e-9) + fs*(pow(fs,2)*(-3.71986872116738e-19*fs - 8.92717448012109e-16) + 2.68486345745707e-10) + 9.99604840391357e-9;

    a2 = Body*(Drive*(Drive*(pow(fs,2)*(-4.38517551032919e-19*pow(fs,2) + 1.02248258747622e-13) + 1.1800994057827e-24) + pow(fs,2)*(4.38517551032919e-19*pow(fs,2) - 7.2835027944254e-14) - 2.48806461666508e-10) + Tone*(Drive*(pow(fs,2)*(-1.0962938775823e-19*pow(fs,2) - 1.64523449411233e-16) + 2.95024851445675e-25) + Tone*(Drive*pow(fs,2)*(9.71269879722608e-20*pow(fs,2) - 7.30868981145362e-15) + pow(fs,2)*(-1.94253975944522e-19*pow(fs,2) + 1.46173796229072e-14)) + pow(fs,2)*(2.1925877551646e-19*pow(fs,2) + 3.29046898822466e-16) - 5.90049702891351e-25) + pow(fs,2)*(4.38517551032919e-19*pow(fs,2) - 1.61074720354358e-13) + 4.97612923333012e-10) + Drive*(Drive*(pow(fs,2)*(-5.57980308175106e-19*pow(fs,2) + 8.91097471854812e-13) - 9.95225846666026e-9) + pow(fs,2)*(5.57980308175106e-19*pow(fs,2) - 7.59195639196014e-13) + 7.43135139705521e-9) + Tone*(Drive*(pow(fs,2)*(-1.39495077043777e-19*pow(fs,2) - 3.66601140557995e-14) + 2.48806461666507e-9) + Tone*(Drive*(pow(fs,2)*(1.37844760272029e-19*pow(fs,2) - 9.23456362873891e-14) - 2.95024851445675e-24) + pow(fs,2)*(-2.75689520544057e-19*pow(fs,2) + 1.84691272574778e-13) + 5.90049702891351e-24) + pow(fs,2)*(2.78990154087553e-19*pow(fs,2) + 7.33202281115989e-14) - 4.97612923333014e-9) + pow(fs,2)*(5.57980308175106e-19*pow(fs,2) - 1.15490113717241e-12) + 1.49940726058704e-8;

    a3 = Body*(Drive*(Drive*(fs*(pow(fs,2)*(2.92345034021946e-19*fs - 3.34644527324554e-16) + 3.89796789944192e-12) + 7.86732937188467e-25) + fs*(pow(fs,2)*(-2.92345034021946e-19*fs + 2.85920354987563e-16) + 1.08278915769268e-13) - 1.65870974444339e-10) + Tone*(Drive*(fs*(pow(fs,2)*(7.30862585054866e-20*fs - 3.23733154656106e-18) + 9.7449197486048e-13) + 1.96683234297117e-25) + Tone*(Drive*fs*(pow(fs,2)*(-6.47513253148406e-20*fs + 3.38477852243932e-17) + 7.37562128614188e-28) + fs*(pow(fs,2)*(1.29502650629681e-19*fs - 6.76955704487864e-17) - 1.47512425722838e-27)) + fs*(pow(fs,2)*(-1.46172517010973e-19*fs + 6.47466309312212e-18) - 1.94898394972096e-12) - 3.93366468594234e-25) + fs*(pow(fs,2)*(-2.92345034021946e-19*fs + 4.32092871998536e-16) - 1.19104615298643e-11) + 3.31741948888675e-10) + Drive*(Drive*(fs*(pow(fs,2)*(3.71986872116738e-19*fs - 7.68721823973197e-16) + 1.99744083365593e-10) - 6.63483897777351e-9) + fs*(pow(fs,2)*(-3.71986872116738e-19*fs + 7.06724011953741e-16) - 1.65372952175536e-10) + 4.95423426470347e-9) + Tone*(Drive*(fs*(pow(fs,2)*(9.29967180291844e-20*fs - 7.04320718137881e-17) - 1.77485923795002e-11) + 1.65870974444338e-9) + Tone*(Drive*(fs*(pow(fs,2)*(-9.18965068480191e-20*fs + 1.30038872970235e-16) - 1.59650812902675e-11) - 1.96683234297117e-24) + fs*(pow(fs,2)*(1.83793013696038e-19*fs - 2.60077745940471e-16) + 3.1930162580535e-11) + 3.93366468594234e-24) + fs*(pow(fs,2)*(-1.85993436058369e-19*fs + 1.40864143627576e-16) + 3.54971847590003e-11) - 3.31741948888676e-9) + fs*(pow(fs,2)*(-3.71986872116738e-19*fs + 8.92717448012109e-16) - 2.68486345745707e-10) + 9.99604840391357e-9;

    a4 = Body*(Drive*(Drive*(fs*(fs*(fs*(-7.30862585054866e-20*fs + 1.67322263662277e-16) - 5.1124129373811e-14) + 1.94898394972096e-12) + 1.96683234297117e-25) + fs*(fs*(fs*(7.30862585054866e-20*fs - 1.42960177493781e-16) + 3.6417513972127e-14) + 5.41394578846342e-14) - 4.14677436110847e-11) + Tone*(Drive*(fs*(fs*(fs*(-1.82715646263716e-20*fs + 1.61866577328053e-18) + 8.22617247056166e-17) + 4.8724598743024e-13) + 4.91708085742792e-26) + Tone*(Drive*fs*(fs*(fs*(1.61878313287101e-20*fs - 1.69238926121966e-17) + 3.65434490572681e-15) + 3.68781064307094e-28) + fs*(fs*(fs*(-3.23756626574203e-20*fs + 3.38477852243932e-17) - 7.30868981145362e-15) - 7.37562128614188e-28)) + fs*(fs*(fs*(3.65431292527433e-20*fs - 3.23733154656106e-18) - 1.64523449411233e-16) - 9.7449197486048e-13) - 9.83416171485584e-26) + fs*(fs*(fs*(7.30862585054866e-20*fs - 2.16046435999268e-16) + 8.0537360177179e-14) - 5.95523076493215e-12) + 8.29354872221687e-11) + Drive*(Drive*(fs*(fs*(fs*(-9.29967180291844e-20*fs + 3.84360911986598e-16) - 4.45548735927406e-13) + 9.98720416827966e-11) - 1.65870974444338e-9) + fs*(fs*(fs*(9.29967180291844e-20*fs - 3.5336200597687e-16) + 3.79597819598007e-13) - 8.2686476087768e-11) + 1.23855856617587e-9) + Tone*(Drive*(fs*(fs*(fs*(-2.32491795072961e-20*fs + 3.52160359068941e-17) + 1.83300570278997e-14) - 8.87429618975008e-12) + 4.14677436110845e-10) + Tone*(Drive*(fs*(fs*(fs*(2.29741267120048e-20*fs - 6.50194364851177e-17) + 4.61728181436945e-14) - 7.98254064513374e-12) - 4.91708085742792e-25) + fs*(fs*(fs*(-4.59482534240096e-20*fs + 1.30038872970235e-16) - 9.23456362873891e-14) + 1.59650812902675e-11) + 9.83416171485584e-25) + fs*(fs*(fs*(4.64983590145922e-20*fs - 7.04320718137881e-17) - 3.66601140557995e-14) + 1.77485923795002e-11) - 8.2935487222169e-10) + fs*(fs*(fs*(9.29967180291844e-20*fs - 4.46358724006055e-16) + 5.77450568586205e-13) - 1.34243172872854e-10) + 2.49901210097839e-9;
};

tiltdrivepro_inclip = _<: ba.if(signbit(_), tiltdrivepro_in_neg_clip, tiltdrivepro_in_clip) :>_ with {

    signbit = ffunction(int signbit(float), "math.h", "");

    tiltdrivepro_in_clip = ffunction(float tiltdrivepro_inclip(float), "tiltdrivepro_in_table.h", "");

    tiltdrivepro_in_neg_clip = ffunction(float tiltdrivepro_in_negclip(float), "tiltdrivepro_in_neg_table.h", "");

};
p2 = pre : fi.iir((b0/a0,b1/a0),(a1/a0)) : tiltdrivepro_out_3clip with {
    LogPot(a, x) = ba.if(a, (exp(a * x) - 1) / (exp(a) - 1), x);
    Inverted(b, x) = ba.if(b, 1 - x, x);
    s = 0.993;
    fs = float(ma.SR);
    pre = _;


    Level = vslider("Level[name:Level]", 0.5, 0, 1, 0.01) : Inverted(0) : LogPot(3) : si.smooth(s);

    b0 = -0.000487217249496405*Level*fs;

    b1 = 0.000487217249496405*Level*fs;

    a0 = 2.08313095376176e-5*fs + 9.71421943566398e-5;

    a1 = -2.08313095376176e-5*fs + 9.71421943566398e-5;
};

tiltdrivepro_out_3clip = _<: ba.if(signbit(_), tiltdrivepro_out_3_neg_clip, tiltdrivepro_out_3_clip) :>_ with {

    signbit = ffunction(int signbit(float), "math.h", "");

    tiltdrivepro_out_3_clip = ffunction(float tiltdrivepro_out_3clip(float), "tiltdrivepro_out_3_table.h", "");

    tiltdrivepro_out_3_neg_clip = ffunction(float tiltdrivepro_out_3_negclip(float), "tiltdrivepro_out_3_neg_table.h", "");

};


amp =  p1 : p2 ;
freq_split = fi.filterbank(3, (86.0,210.0,1200.0,6531.0));
process    = freq_split: ( amp , amp , amp, amp, amp) :>_;
