
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQUiLoader.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QUiLoader>
#include <QDir>
#include <QAction>
#include <QActionGroup>
#include <QLayout>
#include <QWidget>
#include <QChildEvent>
#include <QEvent>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtUiToolsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QUiLoader

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QUiLoader::staticMetaObject);
}


// void QUiLoader::addPluginPath(const QString &path)


static void _init_f_addPluginPath_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addPluginPath_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUiLoader *)cls)->addPluginPath (arg1);
}


// QStringList QUiLoader::availableLayouts()


static void _init_f_availableLayouts_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_availableLayouts_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QUiLoader *)cls)->availableLayouts ());
}


// QStringList QUiLoader::availableWidgets()


static void _init_f_availableWidgets_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_availableWidgets_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QUiLoader *)cls)->availableWidgets ());
}


// void QUiLoader::clearPluginPaths()


static void _init_f_clearPluginPaths_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearPluginPaths_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUiLoader *)cls)->clearPluginPaths ();
}


// QAction *QUiLoader::createAction(QObject *parent, const QString &name)


static void _init_f_createAction_3219 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QAction * > ();
}

static void _call_f_createAction_3219 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QAction * > ((QAction *)((QUiLoader *)cls)->createAction (arg1, arg2));
}


// QActionGroup *QUiLoader::createActionGroup(QObject *parent, const QString &name)


static void _init_f_createActionGroup_3219 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QActionGroup * > ();
}

static void _call_f_createActionGroup_3219 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QActionGroup * > ((QActionGroup *)((QUiLoader *)cls)->createActionGroup (arg1, arg2));
}


// QLayout *QUiLoader::createLayout(const QString &className, QObject *parent, const QString &name)


static void _init_f_createLayout_5136 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("className");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("name", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<QLayout * > ();
}

static void _call_f_createLayout_5136 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QLayout * > ((QLayout *)((QUiLoader *)cls)->createLayout (arg1, arg2, arg3));
}


// QWidget *QUiLoader::createWidget(const QString &className, QWidget *parent, const QString &name)


static void _init_f_createWidget_5149 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("className");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("name", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<QWidget * > ();
}

static void _call_f_createWidget_5149 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QWidget *arg2 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QWidget * > ((QWidget *)((QUiLoader *)cls)->createWidget (arg1, arg2, arg3));
}


// QString QUiLoader::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUiLoader *)cls)->errorString ());
}


// bool QUiLoader::isLanguageChangeEnabled()


static void _init_f_isLanguageChangeEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isLanguageChangeEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUiLoader *)cls)->isLanguageChangeEnabled ());
}


// bool QUiLoader::isTranslationEnabled()


static void _init_f_isTranslationEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isTranslationEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUiLoader *)cls)->isTranslationEnabled ());
}


// QWidget *QUiLoader::load(QIODevice *device, QWidget *parentWidget)


static void _init_f_load_2654 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parentWidget", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<QWidget * > ();
}

static void _call_f_load_2654 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  QWidget *arg2 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QWidget * > ((QWidget *)((QUiLoader *)cls)->load (arg1, arg2));
}


// QStringList QUiLoader::pluginPaths()


static void _init_f_pluginPaths_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_pluginPaths_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QUiLoader *)cls)->pluginPaths ());
}


// void QUiLoader::setLanguageChangeEnabled(bool enabled)


static void _init_f_setLanguageChangeEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLanguageChangeEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUiLoader *)cls)->setLanguageChangeEnabled (arg1);
}


// void QUiLoader::setTranslationEnabled(bool enabled)


static void _init_f_setTranslationEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTranslationEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUiLoader *)cls)->setTranslationEnabled (arg1);
}


// void QUiLoader::setWorkingDirectory(const QDir &dir)


static void _init_f_setWorkingDirectory_1681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QDir & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWorkingDirectory_1681 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDir &arg1 = gsi::arg_reader<const QDir & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUiLoader *)cls)->setWorkingDirectory (arg1);
}


// QDir QUiLoader::workingDirectory()


static void _init_f_workingDirectory_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_workingDirectory_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDir > ((QDir)((QUiLoader *)cls)->workingDirectory ());
}


// static QString QUiLoader::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QUiLoader::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QUiLoader () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addPluginPath", "@brief Method void QUiLoader::addPluginPath(const QString &path)\n", false, &_init_f_addPluginPath_2025, &_call_f_addPluginPath_2025);
  methods += new qt_gsi::GenericMethod ("availableLayouts", "@brief Method QStringList QUiLoader::availableLayouts()\n", true, &_init_f_availableLayouts_c0, &_call_f_availableLayouts_c0);
  methods += new qt_gsi::GenericMethod ("availableWidgets", "@brief Method QStringList QUiLoader::availableWidgets()\n", true, &_init_f_availableWidgets_c0, &_call_f_availableWidgets_c0);
  methods += new qt_gsi::GenericMethod ("clearPluginPaths", "@brief Method void QUiLoader::clearPluginPaths()\n", false, &_init_f_clearPluginPaths_0, &_call_f_clearPluginPaths_0);
  methods += new qt_gsi::GenericMethod ("createAction", "@brief Method QAction *QUiLoader::createAction(QObject *parent, const QString &name)\n", false, &_init_f_createAction_3219, &_call_f_createAction_3219);
  methods += new qt_gsi::GenericMethod ("createActionGroup", "@brief Method QActionGroup *QUiLoader::createActionGroup(QObject *parent, const QString &name)\n", false, &_init_f_createActionGroup_3219, &_call_f_createActionGroup_3219);
  methods += new qt_gsi::GenericMethod ("createLayout", "@brief Method QLayout *QUiLoader::createLayout(const QString &className, QObject *parent, const QString &name)\n", false, &_init_f_createLayout_5136, &_call_f_createLayout_5136);
  methods += new qt_gsi::GenericMethod ("createWidget", "@brief Method QWidget *QUiLoader::createWidget(const QString &className, QWidget *parent, const QString &name)\n", false, &_init_f_createWidget_5149, &_call_f_createWidget_5149);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QUiLoader::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("isLanguageChangeEnabled?|:languageChangeEnabled", "@brief Method bool QUiLoader::isLanguageChangeEnabled()\n", true, &_init_f_isLanguageChangeEnabled_c0, &_call_f_isLanguageChangeEnabled_c0);
  methods += new qt_gsi::GenericMethod ("isTranslationEnabled?|:translationEnabled", "@brief Method bool QUiLoader::isTranslationEnabled()\n", true, &_init_f_isTranslationEnabled_c0, &_call_f_isTranslationEnabled_c0);
  methods += new qt_gsi::GenericMethod ("load", "@brief Method QWidget *QUiLoader::load(QIODevice *device, QWidget *parentWidget)\n", false, &_init_f_load_2654, &_call_f_load_2654);
  methods += new qt_gsi::GenericMethod ("pluginPaths", "@brief Method QStringList QUiLoader::pluginPaths()\n", true, &_init_f_pluginPaths_c0, &_call_f_pluginPaths_c0);
  methods += new qt_gsi::GenericMethod ("setLanguageChangeEnabled|languageChangeEnabled=", "@brief Method void QUiLoader::setLanguageChangeEnabled(bool enabled)\n", false, &_init_f_setLanguageChangeEnabled_864, &_call_f_setLanguageChangeEnabled_864);
  methods += new qt_gsi::GenericMethod ("setTranslationEnabled|translationEnabled=", "@brief Method void QUiLoader::setTranslationEnabled(bool enabled)\n", false, &_init_f_setTranslationEnabled_864, &_call_f_setTranslationEnabled_864);
  methods += new qt_gsi::GenericMethod ("setWorkingDirectory|workingDirectory=", "@brief Method void QUiLoader::setWorkingDirectory(const QDir &dir)\n", false, &_init_f_setWorkingDirectory_1681, &_call_f_setWorkingDirectory_1681);
  methods += new qt_gsi::GenericMethod (":workingDirectory", "@brief Method QDir QUiLoader::workingDirectory()\n", true, &_init_f_workingDirectory_c0, &_call_f_workingDirectory_c0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QUiLoader::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QUiLoader::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QUiLoader::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QUiLoader> decl_QUiLoader (qtdecl_QObject (), "QtUiTools", "QUiLoader_Native",
  methods_QUiLoader (),
  "@hide\n@alias QUiLoader");

GSI_QTUITOOLS_PUBLIC gsi::Class<QUiLoader> &qtdecl_QUiLoader () { return decl_QUiLoader; }

}


class QUiLoader_Adaptor : public QUiLoader, public qt_gsi::QtObjectBase
{
public:

  virtual ~QUiLoader_Adaptor();

  //  [adaptor ctor] QUiLoader::QUiLoader(QObject *parent)
  QUiLoader_Adaptor() : QUiLoader()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QUiLoader::QUiLoader(QObject *parent)
  QUiLoader_Adaptor(QObject *parent) : QUiLoader(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QUiLoader::isSignalConnected(const QMetaMethod &signal)
  bool fp_QUiLoader_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QUiLoader::isSignalConnected(signal);
  }

  //  [expose] int QUiLoader::receivers(const char *signal)
  int fp_QUiLoader_receivers_c1731 (const char *signal) const {
    return QUiLoader::receivers(signal);
  }

  //  [expose] QObject *QUiLoader::sender()
  QObject * fp_QUiLoader_sender_c0 () const {
    return QUiLoader::sender();
  }

  //  [expose] int QUiLoader::senderSignalIndex()
  int fp_QUiLoader_senderSignalIndex_c0 () const {
    return QUiLoader::senderSignalIndex();
  }

  //  [adaptor impl] QAction *QUiLoader::createAction(QObject *parent, const QString &name)
  QAction * cbs_createAction_3219_2(QObject *parent, const QString &name)
  {
    return QUiLoader::createAction(parent, name);
  }

  virtual QAction * createAction(QObject *parent, const QString &name)
  {
    if (cb_createAction_3219_2.can_issue()) {
      return cb_createAction_3219_2.issue<QUiLoader_Adaptor, QAction *, QObject *, const QString &>(&QUiLoader_Adaptor::cbs_createAction_3219_2, parent, name);
    } else {
      return QUiLoader::createAction(parent, name);
    }
  }

  //  [adaptor impl] QActionGroup *QUiLoader::createActionGroup(QObject *parent, const QString &name)
  QActionGroup * cbs_createActionGroup_3219_2(QObject *parent, const QString &name)
  {
    return QUiLoader::createActionGroup(parent, name);
  }

  virtual QActionGroup * createActionGroup(QObject *parent, const QString &name)
  {
    if (cb_createActionGroup_3219_2.can_issue()) {
      return cb_createActionGroup_3219_2.issue<QUiLoader_Adaptor, QActionGroup *, QObject *, const QString &>(&QUiLoader_Adaptor::cbs_createActionGroup_3219_2, parent, name);
    } else {
      return QUiLoader::createActionGroup(parent, name);
    }
  }

  //  [adaptor impl] QLayout *QUiLoader::createLayout(const QString &className, QObject *parent, const QString &name)
  QLayout * cbs_createLayout_5136_2(const QString &className, QObject *parent, const QString &name)
  {
    return QUiLoader::createLayout(className, parent, name);
  }

  virtual QLayout * createLayout(const QString &className, QObject *parent, const QString &name)
  {
    if (cb_createLayout_5136_2.can_issue()) {
      return cb_createLayout_5136_2.issue<QUiLoader_Adaptor, QLayout *, const QString &, QObject *, const QString &>(&QUiLoader_Adaptor::cbs_createLayout_5136_2, className, parent, name);
    } else {
      return QUiLoader::createLayout(className, parent, name);
    }
  }

  //  [adaptor impl] QWidget *QUiLoader::createWidget(const QString &className, QWidget *parent, const QString &name)
  QWidget * cbs_createWidget_5149_2(const QString &className, QWidget *parent, const QString &name)
  {
    return QUiLoader::createWidget(className, parent, name);
  }

  virtual QWidget * createWidget(const QString &className, QWidget *parent, const QString &name)
  {
    if (cb_createWidget_5149_2.can_issue()) {
      return cb_createWidget_5149_2.issue<QUiLoader_Adaptor, QWidget *, const QString &, QWidget *, const QString &>(&QUiLoader_Adaptor::cbs_createWidget_5149_2, className, parent, name);
    } else {
      return QUiLoader::createWidget(className, parent, name);
    }
  }

  //  [emitter impl] void QUiLoader::destroyed(QObject *)
  void emitter_QUiLoader_destroyed_1302(QObject *arg1)
  {
    emit QUiLoader::destroyed(arg1);
  }

  //  [adaptor impl] bool QUiLoader::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QUiLoader::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QUiLoader_Adaptor, bool, QEvent *>(&QUiLoader_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QUiLoader::event(_event);
    }
  }

  //  [adaptor impl] bool QUiLoader::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QUiLoader::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QUiLoader_Adaptor, bool, QObject *, QEvent *>(&QUiLoader_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QUiLoader::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QUiLoader::objectNameChanged(const QString &objectName)
  void emitter_QUiLoader_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QUiLoader::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QUiLoader::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QUiLoader::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QUiLoader_Adaptor, QChildEvent *>(&QUiLoader_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QUiLoader::childEvent(event);
    }
  }

  //  [adaptor impl] void QUiLoader::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QUiLoader::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QUiLoader_Adaptor, QEvent *>(&QUiLoader_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QUiLoader::customEvent(event);
    }
  }

  //  [adaptor impl] void QUiLoader::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QUiLoader::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QUiLoader_Adaptor, const QMetaMethod &>(&QUiLoader_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QUiLoader::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QUiLoader::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QUiLoader::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QUiLoader_Adaptor, QTimerEvent *>(&QUiLoader_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QUiLoader::timerEvent(event);
    }
  }

  gsi::Callback cb_createAction_3219_2;
  gsi::Callback cb_createActionGroup_3219_2;
  gsi::Callback cb_createLayout_5136_2;
  gsi::Callback cb_createWidget_5149_2;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QUiLoader_Adaptor::~QUiLoader_Adaptor() { }

//  Constructor QUiLoader::QUiLoader(QObject *parent) (adaptor class)

static void _init_ctor_QUiLoader_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QUiLoader_Adaptor> ();
}

static void _call_ctor_QUiLoader_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QUiLoader_Adaptor *> (new QUiLoader_Adaptor (arg1));
}


// void QUiLoader::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUiLoader_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QUiLoader_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// QAction *QUiLoader::createAction(QObject *parent, const QString &name)

static void _init_cbs_createAction_3219_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QAction * > ();
}

static void _call_cbs_createAction_3219_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  const QString &arg2 = args.read<const QString & > (heap);
  ret.write<QAction * > ((QAction *)((QUiLoader_Adaptor *)cls)->cbs_createAction_3219_2 (arg1, arg2));
}

static void _set_callback_cbs_createAction_3219_2 (void *cls, const gsi::Callback &cb)
{
  ((QUiLoader_Adaptor *)cls)->cb_createAction_3219_2 = cb;
}


// QActionGroup *QUiLoader::createActionGroup(QObject *parent, const QString &name)

static void _init_cbs_createActionGroup_3219_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QActionGroup * > ();
}

static void _call_cbs_createActionGroup_3219_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  const QString &arg2 = args.read<const QString & > (heap);
  ret.write<QActionGroup * > ((QActionGroup *)((QUiLoader_Adaptor *)cls)->cbs_createActionGroup_3219_2 (arg1, arg2));
}

static void _set_callback_cbs_createActionGroup_3219_2 (void *cls, const gsi::Callback &cb)
{
  ((QUiLoader_Adaptor *)cls)->cb_createActionGroup_3219_2 = cb;
}


// QLayout *QUiLoader::createLayout(const QString &className, QObject *parent, const QString &name)

static void _init_cbs_createLayout_5136_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("className");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<QObject * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("name");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<QLayout * > ();
}

static void _call_cbs_createLayout_5136_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  QObject *arg2 = args.read<QObject * > (heap);
  const QString &arg3 = args.read<const QString & > (heap);
  ret.write<QLayout * > ((QLayout *)((QUiLoader_Adaptor *)cls)->cbs_createLayout_5136_2 (arg1, arg2, arg3));
}

static void _set_callback_cbs_createLayout_5136_2 (void *cls, const gsi::Callback &cb)
{
  ((QUiLoader_Adaptor *)cls)->cb_createLayout_5136_2 = cb;
}


// QWidget *QUiLoader::createWidget(const QString &className, QWidget *parent, const QString &name)

static void _init_cbs_createWidget_5149_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("className");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("name");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<QWidget * > ();
}

static void _call_cbs_createWidget_5149_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  QWidget *arg2 = args.read<QWidget * > (heap);
  const QString &arg3 = args.read<const QString & > (heap);
  ret.write<QWidget * > ((QWidget *)((QUiLoader_Adaptor *)cls)->cbs_createWidget_5149_2 (arg1, arg2, arg3));
}

static void _set_callback_cbs_createWidget_5149_2 (void *cls, const gsi::Callback &cb)
{
  ((QUiLoader_Adaptor *)cls)->cb_createWidget_5149_2 = cb;
}


// void QUiLoader::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUiLoader_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QUiLoader_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QUiLoader::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QUiLoader_Adaptor *)cls)->emitter_QUiLoader_destroyed_1302 (arg1);
}


// void QUiLoader::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUiLoader_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QUiLoader_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QUiLoader::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QUiLoader_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QUiLoader_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QUiLoader::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QUiLoader_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QUiLoader_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QUiLoader::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QUiLoader_Adaptor *)cls)->fp_QUiLoader_isSignalConnected_c2394 (arg1));
}


// emitter void QUiLoader::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QUiLoader_Adaptor *)cls)->emitter_QUiLoader_objectNameChanged_4567 (arg1);
}


// exposed int QUiLoader::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QUiLoader_Adaptor *)cls)->fp_QUiLoader_receivers_c1731 (arg1));
}


// exposed QObject *QUiLoader::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QUiLoader_Adaptor *)cls)->fp_QUiLoader_sender_c0 ());
}


// exposed int QUiLoader::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QUiLoader_Adaptor *)cls)->fp_QUiLoader_senderSignalIndex_c0 ());
}


// void QUiLoader::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUiLoader_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QUiLoader_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QUiLoader> &qtdecl_QUiLoader ();

static gsi::Methods methods_QUiLoader_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUiLoader::QUiLoader(QObject *parent)\nThis method creates an object of class QUiLoader.", &_init_ctor_QUiLoader_Adaptor_1302, &_call_ctor_QUiLoader_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QUiLoader::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("createAction", "@brief Virtual method QAction *QUiLoader::createAction(QObject *parent, const QString &name)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_createAction_3219_2, &_call_cbs_createAction_3219_2);
  methods += new qt_gsi::GenericMethod ("createAction", "@hide", false, &_init_cbs_createAction_3219_2, &_call_cbs_createAction_3219_2, &_set_callback_cbs_createAction_3219_2);
  methods += new qt_gsi::GenericMethod ("createActionGroup", "@brief Virtual method QActionGroup *QUiLoader::createActionGroup(QObject *parent, const QString &name)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_createActionGroup_3219_2, &_call_cbs_createActionGroup_3219_2);
  methods += new qt_gsi::GenericMethod ("createActionGroup", "@hide", false, &_init_cbs_createActionGroup_3219_2, &_call_cbs_createActionGroup_3219_2, &_set_callback_cbs_createActionGroup_3219_2);
  methods += new qt_gsi::GenericMethod ("createLayout", "@brief Virtual method QLayout *QUiLoader::createLayout(const QString &className, QObject *parent, const QString &name)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_createLayout_5136_2, &_call_cbs_createLayout_5136_2);
  methods += new qt_gsi::GenericMethod ("createLayout", "@hide", false, &_init_cbs_createLayout_5136_2, &_call_cbs_createLayout_5136_2, &_set_callback_cbs_createLayout_5136_2);
  methods += new qt_gsi::GenericMethod ("createWidget", "@brief Virtual method QWidget *QUiLoader::createWidget(const QString &className, QWidget *parent, const QString &name)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_createWidget_5149_2, &_call_cbs_createWidget_5149_2);
  methods += new qt_gsi::GenericMethod ("createWidget", "@hide", false, &_init_cbs_createWidget_5149_2, &_call_cbs_createWidget_5149_2, &_set_callback_cbs_createWidget_5149_2);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QUiLoader::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QUiLoader::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QUiLoader::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QUiLoader::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QUiLoader::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QUiLoader::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QUiLoader::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QUiLoader::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QUiLoader::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QUiLoader::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QUiLoader::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QUiLoader_Adaptor> decl_QUiLoader_Adaptor (qtdecl_QUiLoader (), "QtUiTools", "QUiLoader",
  methods_QUiLoader_Adaptor (),
  "@qt\n@brief Binding of QUiLoader");

}

