/**
 * @param {import("../../size.js").Size} size Canvas size in css pixels.
 * @param {Array<import("../../transform.js").Transform>} transforms Transforms
 * for rendering features to all worlds of the viewport, from coordinates to css
 * pixels.
 * @param {Array<import("../../Feature.js").FeatureLike>} features
 * Features to consider for hit detection.
 * @param {import("../../style/Style.js").StyleFunction|undefined} styleFunction
 * Layer style function.
 * @param {import("../../extent.js").Extent} extent Extent in render projection.
 * @param {number} resolution Resolution.
 * @param {number} rotation Rotation.
 * @param {number} [squaredTolerance] Squared tolerance.
 * @param {import("../../proj/Projection.js").default} [projection] Render projection.
 * @return {ImageData} Hit detection image data.
 */
export function createHitDetectionImageData(size: import("../../size.js").Size, transforms: Array<import("../../transform.js").Transform>, features: Array<import("../../Feature.js").FeatureLike>, styleFunction: import("../../style/Style.js").StyleFunction | undefined, extent: import("../../extent.js").Extent, resolution: number, rotation: number, squaredTolerance?: number, projection?: import("../../proj/Projection.js").default): ImageData;
/**
 * @param {import("../../pixel").Pixel} pixel Pixel coordinate on the hit
 * detection canvas in css pixels.
 * @param {Array<F>} features Features. Has to
 * match the `features` array that was passed to `createHitDetectionImageData()`.
 * @param {ImageData} imageData Hit detection image data generated by
 * `createHitDetectionImageData()`.
 * @return {Array<F>} Features.
 * @template {import("../../Feature.js").FeatureLike} F
 */
export function hitDetect<F extends import("../../Feature.js").FeatureLike>(pixel: import("../../pixel").Pixel, features: Array<F>, imageData: ImageData): Array<F>;
export const HIT_DETECT_RESOLUTION: 0.5;
//# sourceMappingURL=hitdetect.d.ts.map