#ifndef _PGM_INTERACTIVE_TESTS_H
#define _PGM_INTERACTIVE_TESTS_H

Suite * pgm_text_suite (void);
Suite * pgm_image_suite (void);

extern PgmViewport *interactive_test_viewport;
extern const gchar *pgm_current_test_name;
extern gboolean pgm_screenshot_mode;

void pgm_interactive_test_start (void);
void pgm_interactive_test_end (void);
void pgm_interactive_test_suite_start (void);
void pgm_interactive_test_suite_end (void);

gboolean pgm_interactive_test_ask_user (void);

/* This should be called in the test function if the rendering won't be finished
 * when the test function returns.
 * Should be called in the same thread as the test function.
 */
void pgm_interactive_test_asynchronous_rendering (void);

/* In asynchronous rendering (pgm_interactive_test_asynchronous_rendering() has
 * been called), this function should be called (e.g. by a callback) when the
 * rendering is done.
 * Should be called in the same thread as the test function.
 */
void pgm_interactive_test_rendering_done (void);

#define PGM_INTERACTIVE_TESTS_SET_FIXTURES(test_case)             \
    do{                                                                     \
      tcase_add_checked_fixture (test_case, pgm_interactive_test_start,     \
                                 pgm_interactive_test_end);                 \
    }while(0)

#define PGM_START_INTERACTIVE_TEST(test_name)                                 \
    PGM_START_TEST (test_name)                                                \
    {                                                                         \
      gboolean test_result = FALSE;                                           \
      pgm_current_test_name = #test_name;                                     \
      pgm_viewport_set_title (interactive_test_viewport, pgm_current_test_name);


#define PGM_END_INTERACTIVE_TEST                                              \
      test_result = pgm_interactive_test_ask_user();                          \
      fail_unless (test_result, pgm_current_test_name);                       \
    }                                                                         \
    PGM_END_TEST


#endif /* _PGM_INTERACTIVE_TESTS_H */
