package "PrIME-ReconciliationPredictor"
version "1.0"
purpose "1. Computes speciation probabilities for fixed and variable gene tree cases (given a dated specie tree)
2. Draws consensus tree"
    
args "--unamed-opts"

option "silent" s "No diagnostics printed on stdout." flag off

section "Fixing" sectiondesc="Options related to fixing gene tree vertices"
option "fix" x "Fix a gene tree vertex at its MPR value" flag off
option "leaves" e "Vertices to fix (semi-colon seperated list of gene tree leaves (sequences). For instance Popy-A01;Popy-A02;Gogo-A0101)" default="none" string optional

section "MCMC" sectiondesc="Options related to MCMC"
option "mcmc" M "Perform MCMC calculations." flag off
option "iterations" i "Number of iterations in MCMC." int default="1000" optional
option "thinning" j "Thinning, or the number of MCMC iterations to skip before sampling." int default="10" optional
option "timestep" t "Approximate discretization timestep. Set to 0 to divide every edge in equally many parts (see -m)." float default="0.05" optional
option "min-intervals" m "Minimum number of parts to slice each edge in. If -t is set to 0, this becomes the exact number of parts. Minimum 2." int default="3" optional
option "substitution-model" u "Substitution model used." string default="JTT" optional
option "output-folder" f "Output folder for consensus tree." string default="~/primeinstall/bin" optional
option "virtual-vertex-file" v "Output file for virtual vertex probabilities." string default="VirtualVerticesProbabilities.txt" optional
option "gsr-spec-output-file" g "Output file for gsr speciation probabilities." string default="GSRSpeciationProbabilities.txt" optional
option "ctree-svg-file" C "Output file for consensus tree diagram." string default="VVTree.fig" optional


section "Consensus tree" sectiondesc="Options related to the consensus tree"
option "output-file" o "Output file for consensus tree." string typestr="filename" optional
option "no-speciation-probabilities" p "Do not calculate speciation probabilities" flag off 
option "burn-in" b "burn-in value to be used for the GSR samples" int default="10000" optional

#The idea is to have the option to either get input trees from a file generated by primeGSR
#or perform an MCMC run combined with a consensus tree calculation directly in orthoProject
#it is more safe to have orthoProject do the MCMC calculations; otherwise the very same parameters
#given to primeLSD must be given to orthoProject to get reliable probabilities. More precisely,
#the parameters are timestep and min_intervals for the discretized tree, and
#density function for rate probabilities. Right now, only a gamma distribution is used.
#Also, right now the only substitution model used is JTT, so sequences must be protein sequences.
usage "orthoProject [OPTIONS] <sequences/samples> <species tree> <gs-map>"
#usage "orthoProject [OPTIONS] -M <sequences> <species tree> <gs-map>"

description "<sequences/samples> is either <sequences> or <samples>, choose one (see below).
<sequences> is a file with protein sequences in fasta format with ids consistent with those in <gs-map>.
<samples> is the name of a file containing mcmc samples as output by primeLSD.
<species tree> is the name of a file containing the species tree.
<gs-map> is the gene-to-species map."

text "
If the flag -M is given an MCMC run is performed. In this case, use <sequences>. If -M is NOT given a file with samples must be given, i.e. use <samples>.
The format of the file <samples> is the same as the output of primeLSD with the option -o.
This makes it easy to first perform an MCMC sampling with primeLSD, then immediately apply orthoProject to the output file together with the species tree to create a consensus tree.
The output of orthoProject is a consensus tree, which by default is written on stdout. "


