<!--
------------------( LICENSE                                  )------------------
Copyright (c) 2014-2025 Beartype authors.
See "LICENSE" for further details.

------------------( SYNOPSIS                                 )------------------
GitHub-specific security policy, describing with human-readable language the
process by which responsible end users submit security vulnerabilities as
initially private GitHub-managed security advisories targeting this repository.

------------------( SEE ALSO                                 )------------------
* Official GitHub documentation on this file format:
  https://docs.github.com/en/code-security/getting-started/adding-a-security-policy-to-your-repository

..................{ FIXME                                    }..................
TODO: Generalize this into a @beartype organization-wide security policy. To do
so, we'll need to create a new public "beartype/.github" repository, referred to
as a "community health repository" in GitHub parlance. See also:
    https://docs.github.com/en/communities/setting-up-your-project-for-healthy-contributions/creating-a-default-community-health-file
-->

![we doin' this](https://raw.githubusercontent.com/beartype/beartype-assets/main/brand/brand-2600x800.png)

# Report a Vulnerability Today for a Future Tomorrow

Please report *any* security issue whatsoever in the [@beartype
ecosystem][@beartype] by privately submitting:

* A [**New draft security
  advisory**](https://github.com/beartype/beartype/security/advisories/new) –
  also
  accessible via the [**Advisories**
  tab](https://github.com/beartype/beartype/security/advisories) of the
  [**Security** pane](https://github.com/beartype/beartype/security) for this
  public GitHub repository.

Our gratitude is infinite. Open-source software improves the mutual security of
humanity through openness, transparency, and many eyeballs. You are those
eyeballs.

# We Secure Your Software So You Don't Have To

Despite the thrilling puns that even now bedevil our documentation,
[@beartype][] is a production-grade family of quality assurance (QA) devtooling
leveraged by security-conscious governments, corporations,
non-profits, and citizens the world over – including the United Kingdom's very
own [Government Communications Headquarters
(GCHQ)](https://en.wikipedia.org/wiki/GCHQ).

[@beartype maintainers](https://github.com/leycec),
[developers](https://github.com/beartype/beartype/graphs/contributors), and
[users alike](https://github.com/beartype/beartype/network/dependents) treat
security concerns with the gravity they deserve. You care about security. So do
we. Your concerns concern us. We humbly appreciate your efforts to responsibly
disclose security vulnerabilities. In return, we *will* act swiftly to:

1. Privately **reply** to your private disclosure with bald-faced panic. Just
   kidding! We'll inform you about what happens next. Some amount of panicking
   might be involved. Ideally, not much.
1. Privately **communicate** with you during our resolution process. This is
   where the "fun" happens. We might request additional information, guidance,
   metadata, and spiritual support.
1. Publicly **publish** a new stable release resolving these vulnerabilities.
1. Publicly **disclose** the vulnerabilities you discovered, usually alongside
   a [new
   **Announcement**](https://github.com/beartype/beartype/discussions/categories/announcements)
   announcing the aforementioned new stable release in the [**Discussion**
   forums](https://github.com/beartype/beartype/discussions) for this public
   GitHub repository. Our public disclosure will document this vulnerability in
   detail – including some or all of:
   * Which **@beartype features** are affected.
   * How @beartype users can **strategically mitigate** this vulnerability. The
     answer usually reduces to: "Update @beartype and pray for your safety!"
     We'll embellish this answer with animated memes that make the @beartype
     userbase superficially feel better about what actually is a deep tragedy.
   * How you **personally discovered** this vulnerability.
1. Publicly **acknowledge** your invaluable personal contributions.

Our gratitude intensifies. Your eyeballs continue to make the world a safer
place. Bet you didn't know your eyeballs could do that, huh? Yet they did. When
humanity is secured, quality is assured.

[@beartype]: https://github.com/beartype
