// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by go/autofill-i18n-model-git. Do not
// manually edit.

#ifndef COMPONENTS_AUTOFILL_CORE_BROWSER_DATA_MODEL_AUTOFILL_I18N_PARSING_EXPRESSIONS_H_
#define COMPONENTS_AUTOFILL_CORE_BROWSER_DATA_MODEL_AUTOFILL_I18N_PARSING_EXPRESSIONS_H_

#include "base/containers/fixed_flat_map.h"
#include "base/containers/flat_map.h"
#include "base/containers/span.h"
#include "base/memory/raw_ptr.h"
#include "components/autofill/core/browser/data_model/autofill_i18n_parsing_expression_components.h"
#include "components/autofill/core/browser/field_types.h"
#include "third_party/re2/src/re2/re2.h"

namespace autofill::i18n_model_definition {
namespace {

using CountryAndFieldType = std::pair<std::string_view, FieldType>;

// Section for regular expressions.
inline constexpr char kRegularExpression_1[] = "(?m)(?i:(?P<ADDRESS_HOME_STREET_LOCATION>\\A\\s*(?P<ADDRESS_HOME_STREET_NAME>(?:[^\\s,]+(?:[^\\S\\r\\n]+[^\\s,]+)*?))(?:(?:,\\s*|\\s+-\\s+|\\s+)(?i:nº\\s+)?(?P<ADDRESS_HOME_HOUSE_NUMBER>(?:KM\\s+)?\\d+\\w?))))"; // nocheck
inline constexpr char kRegularExpression_2[] = "(?m)(?i:(?P<ADDRESS_HOME_APT>(?P<ADDRESS_HOME_APT_TYPE>(?:apto\\.?|apt\\.?|apartamento|sala nº|sala|conjunto))(?:(?:^|\\s+)(?P<ADDRESS_HOME_APT_NUM>(?:\\d+\\w?\\b|\\w\\b)))))"; // nocheck
inline constexpr char kRegularExpression_3[] = "(?m)(?i:(?:andar\\s*(?P<ADDRESS_HOME_FLOOR>\\d+)))"; // nocheck
inline constexpr char kRegularExpression_4[] = "(?m)(?i:(?:(?:[,-]\\s*|^)(?P<ADDRESS_HOME_FLOOR>\\d+)\\s*(?:º\\s*)?andar(?:\\s*[,-]|$)))"; // nocheck
inline constexpr char kRegularExpression_5[] = "(?m)(?i:(?:(?:ponto de )?refer[êe]ncia(?::\\s*|\\s+)(?P<ADDRESS_HOME_LANDMARK>[^,\\n]+)))"; // nocheck
inline constexpr char kRegularExpression_6[] = "(?m)(?i:(?P<ADDRESS_HOME_APT>(?P<ADDRESS_HOME_APT_TYPE>(?:apto\\.?|apt\\.?|apartamento|sala nº|sala|conjunto))?(?:(?:^|\\s+)(?P<ADDRESS_HOME_APT_NUM>(?:\\d+\\w?\\b|\\w\\b)))))"; // nocheck
inline constexpr char kRegularExpression_7[] = "(?m)(?i:(?P<ADDRESS_HOME_STREET_LOCATION>\\A\\s*(?P<ADDRESS_HOME_STREET_NAME>(?:[^\\s,]+(?:[^\\S\\r\\n]+[^\\s,]+)*?))(?:(?:^|[,\\s]+)(?:(?:no|°|º|nummer|number)[-.\\s]*)?(?P<ADDRESS_HOME_HOUSE_NUMBER>\\d+(?:\\s*[[:alpha:]]\\b|\\s*[\\/-]\\s*\\d+)?))))"; // nocheck
inline constexpr char kRegularExpression_8[] = "(?m)(?i:(?P<ADDRESS_HOME_STREET_ADDRESS>(?P<ADDRESS_HOME_STREET_LOCATION>\\A\\s*(?P<ADDRESS_HOME_STREET_NAME>(?:[^\\s,]+(?:[^\\S\\r\\n]+[^\\s,]+)*?))(?:(?:^|[,\\s]+)(?:(?:no|°|º|nummer|number)[-.\\s]*)?(?P<ADDRESS_HOME_HOUSE_NUMBER>\\d+(?:\\s*[[:alpha:]]\\b|\\s*[\\/-]\\s*\\d+)?)))(?:(?:^|[,\\s]+)(?P<ADDRESS_HOME_OVERFLOW>(?:[^\\s,]+(?:[^\\S\\r\\n]+[^\\s,]+)*?)))?))"; // nocheck
inline constexpr char kRegularExpression_9[] = "(?m)(?i:(?P<ADDRESS_HOME_STREET_LOCATION>\\A\\s*(?P<ADDRESS_HOME_STREET_NAME>(?:calle\\s+\\d+\\s+[^\\d,\\n\\r]*?|(?:[^\\s,]+(?:[^\\S\\r\\n]+[^\\s,]+)*?)))(?:[,]?\\s+?(?:(?:#|No\\.?|número\\s)\\s*)?(?P<ADDRESS_HOME_HOUSE_NUMBER>(?:(?:S/Num\\.?|S/N|Sin Nombre)|(?:KM\\s+)?\\d+\\w?)))))"; // nocheck
inline constexpr char kRegularExpression_10[] = "(?m)(?i:(?P<ADDRESS_HOME_APT>(?P<ADDRESS_HOME_APT_TYPE>(?:despacho|loc\\.?|local|int(?:erior|\\.?)|n[uú]m(?:ero|\\.)? int(?:erno|\\.)?|Apartamento|Apto\\.?|Departamento|apto\\.?))(?:(?:^|\\s+)(?P<ADDRESS_HOME_APT_NUM>(?:\\d+\\w?\\b|\\w\\b))\\b)))"; // nocheck
inline constexpr char kRegularExpression_11[] = "(?m)(?i:(?:piso\\s*(?P<ADDRESS_HOME_FLOOR>\\d+)))"; // nocheck
inline constexpr char kRegularExpression_12[] = "(?m)(?i:(?:\\b(?:x|Entre( Calles)?)\\s+(?P<ADDRESS_HOME_BETWEEN_STREETS>(?P<ADDRESS_HOME_BETWEEN_STREETS_1>(?:[^\\s,]+(?:[^\\S\\r\\n]+[^\\s,]+)*?))(?:\\s+y\\s+)(?P<ADDRESS_HOME_BETWEEN_STREETS_2>(?:[^,\\r\\n]+)))))"; // nocheck
inline constexpr char kRegularExpression_13[] = "(?m)(?i:(?:(?:Cerca del)(?P<ADDRESS_HOME_LANDMARK>[^,\\n]+)))"; // nocheck
inline constexpr char kRegularExpression_14[] = "(?m)(?i:(?P<ADDRESS_HOME_APT>(?P<ADDRESS_HOME_APT_TYPE>(?:despacho|loc\\.?|local|int(?:erior|\\.?)|n[uú]m(?:ero|\\.)? int(?:erno|\\.)?|Apartamento|Apto\\.?|Departamento|apto\\.?))?(?:(?:^|\\s+)(?P<ADDRESS_HOME_APT_NUM>(?:\\d+\\w?\\b|\\w\\b)))))"; // nocheck
inline constexpr char kRegularExpression_15[] = "(?m)(?i:(?P<ADDRESS_HOME_STREET_ADDRESS>(?:(?:(?:((no|°|º|number)(\\.|-|\\s)*)?)(?P<ADDRESS_HOME_HOUSE_NUMBER>(?:\\d+\\w?))(th\\.|\\.)?)(?:(?:^|\\s+)(?P<ADDRESS_HOME_STREET_NAME>(?:[^\\s,]+(?:[^\\S\\r\\n]+[^\\s,]+)*?)))|(?P<ADDRESS_HOME_STREET_NAME__2>(?:[^\\s,]+(?:[^\\S\\r\\n]+[^\\s,]+)*?))(?:(?:^|[,\\s]+)(?:((no|°|º|number)(\\.|-|\\s)*)?)(?P<ADDRESS_HOME_HOUSE_NUMBER__2>(?:\\d+\\w?))(th\\.|\\.)?))(?:(?:^|[,\\s]+)(?P<ADDRESS_HOME_SUBPREMISE>(?:(?:(?:(?:(°|º|\\.|\\s|-)*(floor|flur|fl|og|obergeschoss|ug|untergeschoss|geschoss|andar|piso|º)(\\.|\\s|-)*)(?P<ADDRESS_HOME_FLOOR>(?:(\\d{0,3}\\w?))))|(?:(?P<ADDRESS_HOME_FLOOR__2>(?:(\\d{1,3}\\w?|\\w)))(?:(°|º|\\.|\\s|-)*(floor|flur|fl|og|obergeschoss|ug|untergeschoss|geschoss|andar|piso|º)(\\.|\\s|-)*)))(?:(?:^|[,\\s]+)(?:(?:(?:(apt|apartment|wohnung|apto|-)(\\.|\\s|-)*)(?P<ADDRESS_HOME_APT_NUM>(?:(\\d{0,3}\\w?))))|(?:(-\\s*)?(?P<ADDRESS_HOME_APT_NUM__2>(?:(\\d{1,3}\\w?|\\w)))(?:(\\.|\\s|-)*(ª)))?))?|(?:(?:(?:(apt|apartment|wohnung|apto|-)(\\.|\\s|-)*)(?P<ADDRESS_HOME_APT_NUM__3>(?:(\\d{0,3}\\w?))))|(?:(-\\s*)?(?P<ADDRESS_HOME_APT_NUM__4>(?:(\\d{1,3}\\w?|\\w)))(?:(\\.|\\s|-)*(ª)))?))))?))"; // nocheck


// Section for singular decomposition(s).
inline constexpr Decomposition kDecompositionList[] = {
    Decomposition(kRegularExpression_1, true, true),
    Decomposition(kRegularExpression_6, true, true),
    Decomposition(kRegularExpression_7, true, true),
    Decomposition(kRegularExpression_8, true, true),
    Decomposition(kRegularExpression_9, true, true),
    Decomposition(kRegularExpression_12, true, true),
    Decomposition(kRegularExpression_14, true, true),
    Decomposition(kRegularExpression_15, true, true),
};

// Section for singular extract part(s).
inline constexpr ExtractPart kExtractPartList[]{
    ExtractPart("", kRegularExpression_2),
    ExtractPart("", kRegularExpression_3),
    ExtractPart("", kRegularExpression_4),
    ExtractPart("", kRegularExpression_5),
    ExtractPart("", kRegularExpression_1),
    ExtractPart("", kRegularExpression_10),
    ExtractPart("", kRegularExpression_11),
    ExtractPart("", kRegularExpression_13),
    ExtractPart("", kRegularExpression_12),
    ExtractPart("", kRegularExpression_9),
};

// Section for decomposition cascades and their alternatives.

// Section for extract parts and their pieces.
inline constexpr ExtractPart const* kExtractParts_0_Pieces[]{&kExtractPartList[0],&kExtractPartList[1],&kExtractPartList[2]};
inline constexpr ExtractParts kExtractParts_0 = ExtractParts("", kExtractParts_0_Pieces);
inline constexpr ExtractPart const* kExtractParts_1_Pieces[]{&kExtractPartList[0],&kExtractPartList[1],&kExtractPartList[2]};
inline constexpr ExtractParts kExtractParts_1 = ExtractParts("", kExtractParts_1_Pieces);
inline constexpr ExtractPart const* kExtractParts_2_Pieces[]{&kExtractPartList[0],&kExtractPartList[1],&kExtractPartList[2],&kExtractPartList[3]};
inline constexpr ExtractParts kExtractParts_2 = ExtractParts("", kExtractParts_2_Pieces);
inline constexpr ExtractPart const* kExtractParts_3_Pieces[]{&kExtractPartList[4],&kExtractPartList[0],&kExtractPartList[1],&kExtractPartList[2],&kExtractPartList[3]};
inline constexpr ExtractParts kExtractParts_3 = ExtractParts("", kExtractParts_3_Pieces);
inline constexpr ExtractPart const* kExtractParts_4_Pieces[]{&kExtractPartList[5],&kExtractPartList[6]};
inline constexpr ExtractParts kExtractParts_4 = ExtractParts("", kExtractParts_4_Pieces);
inline constexpr ExtractPart const* kExtractParts_5_Pieces[]{&kExtractPartList[7],&kExtractPartList[8]};
inline constexpr ExtractParts kExtractParts_5 = ExtractParts("", kExtractParts_5_Pieces);
inline constexpr ExtractPart const* kExtractParts_6_Pieces[]{&kExtractPartList[7],&kExtractPartList[8]};
inline constexpr ExtractParts kExtractParts_6 = ExtractParts("", kExtractParts_6_Pieces);
inline constexpr ExtractPart const* kExtractParts_7_Pieces[]{&kExtractPartList[9],&kExtractPartList[5],&kExtractPartList[6],&kExtractPartList[7],&kExtractPartList[8]};
inline constexpr ExtractParts kExtractParts_7 = ExtractParts("", kExtractParts_7_Pieces);
}  // namespace

// A lookup map for parsing expressions for countries and field types.
inline constexpr auto kAutofillParsingRulesMap =
    base::MakeFixedFlatMap<CountryAndFieldType, const AutofillParsingProcess*>({
      {{"BR", ADDRESS_HOME_STREET_LOCATION}, &kDecompositionList[0]},
      {{"BR", ADDRESS_HOME_SUBPREMISE}, &kExtractParts_0},
      {{"BR", ADDRESS_HOME_OVERFLOW}, &kExtractParts_1},
      {{"BR", ADDRESS_HOME_OVERFLOW_AND_LANDMARK}, &kExtractParts_2},
      {{"BR", ADDRESS_HOME_STREET_ADDRESS}, &kExtractParts_3},
      {{"BR", ADDRESS_HOME_APT}, &kDecompositionList[1]},
      {{"DE", ADDRESS_HOME_STREET_LOCATION}, &kDecompositionList[2]},
      {{"DE", ADDRESS_HOME_STREET_ADDRESS}, &kDecompositionList[3]},
      {{"MX", ADDRESS_HOME_STREET_LOCATION}, &kDecompositionList[4]},
      {{"MX", ADDRESS_HOME_SUBPREMISE}, &kExtractParts_4},
      {{"MX", ADDRESS_HOME_BETWEEN_STREETS}, &kDecompositionList[5]},
      {{"MX", ADDRESS_HOME_BETWEEN_STREETS_OR_LANDMARK}, &kExtractParts_5},
      {{"MX", ADDRESS_HOME_OVERFLOW}, &kExtractParts_6},
      {{"MX", ADDRESS_HOME_STREET_ADDRESS}, &kExtractParts_7},
      {{"MX", ADDRESS_HOME_APT}, &kDecompositionList[6]},
      {{"XX", ADDRESS_HOME_STREET_ADDRESS}, &kDecompositionList[7]}
      });

}  // namespace autofill::i18n_model_definition

#endif  // COMPONENTS_AUTOFILL_CORE_BROWSER_DATA_MODEL_AUTOFILL_I18N_PARSING_EXPRESSIONS_H_
