% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{draw_plot_label}
\alias{draw_plot_label}
\title{Add a label to a plot}
\usage{
draw_plot_label(label, x = 0, y = 1, hjust = -0.5, vjust = 1.5,
  size = 16, fontface = "bold", family = NULL, color = NULL,
  colour, ...)
}
\arguments{
\item{label}{String (or vector of strings) to be drawn as the label.}

\item{x}{The x position (or vector thereof) of the label(s).}

\item{y}{The y position (or vector thereof) of the label(s).}

\item{hjust}{Horizontal adjustment.}

\item{vjust}{Vertical adjustment.}

\item{size}{Font size of the label to be drawn.}

\item{fontface}{Font face of the label to be drawn.}

\item{family}{(optional) Font family of the plot labels. If not provided, is taken from the current theme.}

\item{color, colour}{(optional) Color of the plot labels. If not provided, is taken from the current theme.}

\item{...}{Other arguments to be handed to \code{draw_text}.}
}
\description{
This function adds a plot label to the upper left corner of a graph (or an arbitrarily specified position). It takes all the same parameters
as \code{draw_text}, but has defaults that make it convenient to label graphs with letters A, B, C, etc. Just like \code{draw_text()},
it can handle vectors of labels with associated coordinates.
}
