% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dof.R
\name{degrees_of_freedom}
\alias{degrees_of_freedom}
\alias{dof}
\title{Degrees of Freedom (DoF)}
\usage{
degrees_of_freedom(model, method = "analytical", ...)

dof(model, method = "analytical", ...)
}
\arguments{
\item{model}{A statistical model.}

\item{method}{Type of approximation for the degrees of freedom. Can be one of
the following:
\itemize{
\item \code{"residual"} (aka \code{"analytical"}) returns the residual degrees of
freedom, which usually is what \code{\link[stats:df.residual]{stats::df.residual()}} returns. If a
model object has no method to extract residual degrees of freedom, these
are calculated as \code{n-p}, i.e. the number of observations minus the number
of estimated parameters. If residual degrees of freedom cannot be extracted
by either approach, returns \code{Inf}.
\item \code{"wald"} returns residual (aka analytical) degrees of freedom for models
with t-statistic, \code{1} for models with Chi-squared statistic, and \code{Inf} for
all other models. Also returns \code{Inf} if residual degrees of freedom cannot
be extracted.
\item \code{"normal"} always returns \code{Inf}.
\item \code{"model"} returns model-based degrees of freedom, i.e. the number of
(estimated) parameters.
\item For mixed models, can also be \code{"ml1"} (or \code{"m-l-1"}, approximation of
degrees of freedom based on a "m-l-1" heuristic as suggested by \emph{Elff et
al. 2019}) or \code{"between-within"} (or \code{"betwithin"}).
\item For mixed models of class \code{merMod}, \code{type} can also be \code{"satterthwaite"}
or \code{"kenward-roger"} (or \code{"kenward"}). See 'Details'.
}

Usually, when degrees of freedom are required to calculate p-values or
confidence intervals, \code{type = "wald"} is likely to be the best choice in
most cases.}

\item{...}{Currently not used.}
}
\description{
Estimate or extract degrees of freedom of models parameters.
}
\note{
In many cases, \code{degrees_of_freedom()} returns the same as \code{df.residuals()},
or \code{n-k} (number of observations minus number of parameters). However,
\code{degrees_of_freedom()} refers to the model's \emph{parameters} degrees of freedom
of the distribution for the related test statistic. Thus, for models with
z-statistic, results from \code{degrees_of_freedom()} and \code{df.residuals()} differ.
Furthermore, for other approximation methods like \code{"kenward"} or
\code{"satterthwaite"}, each model parameter can have a different degree of
freedom.
}
\examples{
\dontshow{if (require("lme4", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
model <- lm(Sepal.Length ~ Petal.Length * Species, data = iris)
dof(model)

model <- glm(vs ~ mpg * cyl, data = mtcars, family = "binomial")
dof(model)
\donttest{
model <- lmer(Sepal.Length ~ Petal.Length + (1 | Species), data = iris)
dof(model)

if (require("rstanarm", quietly = TRUE)) {
  model <- stan_glm(
    Sepal.Length ~ Petal.Length * Species,
    data = iris,
    chains = 2,
    refresh = 0
  )
  dof(model)
}
}
\dontshow{\}) # examplesIf}
}
