% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly.R
\name{plot_ly}
\alias{plot_ly}
\title{Initiate a plotly visualization}
\usage{
plot_ly(data = data.frame(), ..., type = NULL, color, colors = NULL,
  alpha = 1, symbol, symbols = NULL, size, sizes = c(10, 100), linetype,
  linetypes = NULL, split, frame, width = NULL, height = NULL,
  source = "A")
}
\arguments{
\item{data}{A data frame (optional) or \link[crosstalk:SharedData]{crosstalk::SharedData} object.}

\item{...}{These arguments are documented at \url{https://plot.ly/r/reference/}
Note that acceptable arguments depend on the value of \code{type}.}

\item{type}{A character string describing the type of trace.}

\item{color}{A formula containing a name or expression.
Values are scaled and mapped to color codes based on the value of
\code{colors} and \code{alpha}. To avoid scaling, wrap with \code{\link[=I]{I()}},
and provide value(s) that can be converted to rgb color codes by
\code{\link[grDevices:col2rgb]{grDevices::col2rgb()}}.}

\item{colors}{Either a colorbrewer2.org palette name (e.g. "YlOrRd" or "Blues"),
or a vector of colors to interpolate in hexadecimal "#RRGGBB" format,
or a color interpolation function like \code{colorRamp()}.}

\item{alpha}{A number between 0 and 1 specifying the alpha channel applied to color.}

\item{symbol}{A formula containing a name or expression.
Values are scaled and mapped to symbols based on the value of \code{symbols}.
To avoid scaling, wrap with \code{\link[=I]{I()}}, and provide valid
\code{\link[=pch]{pch()}} values and/or valid plotly symbol(s) as a string}

\item{symbols}{A character vector of symbol types.
Either valid \link{pch} or plotly symbol codes may be supplied.}

\item{size}{A formula containing a name or expression yielding a numeric vector.
Values are scaled according to the range specified in \code{sizes}.}

\item{sizes}{A numeric vector of length 2 used to scale sizes to pixels.}

\item{linetype}{A formula containing a name or expression.
Values are scaled and mapped to linetypes based on the value of
\code{linetypes}. To avoid scaling, wrap with \code{\link[=I]{I()}}.}

\item{linetypes}{A character vector of line types.
Either valid \link{par} (lty) or plotly dash codes may be supplied.}

\item{split}{A formula containing a name or expression. Similar to
\code{\link[=group_by]{group_by()}}, but ensures at least one trace for each unique
value. This replaces the functionality of the (now deprecated)
\code{group} argument.}

\item{frame}{A formula containing a name or expression. The resulting value
is used to split data into frames, and then animated.}

\item{width}{Width in pixels (optional, defaults to automatic sizing).}

\item{height}{Height in pixels (optional, defaults to automatic sizing).}

\item{source}{a character string of length 1. Match the value of this string
with the source argument in \code{\link[=event_data]{event_data()}} to retrieve the
event data corresponding to a specific plot (shiny apps can have multiple plots).}
}
\description{
Transform data into a plotly visualization.
}
\details{
There are a number of "visual properties" that aren't included in the official
Reference section (see below).
}
\examples{
\dontrun{

# plot_ly() tries to create a sensible plot based on the information you 
# give it. If you don't provide a trace type, plot_ly() will infer one.
plot_ly(economics, x = ~pop)
plot_ly(economics, x = ~date, y = ~pop)
# plot_ly() doesn't require data frame(s), which allows one to take 
# advantage of trace type(s) designed specifically for numeric matrices
plot_ly(z = ~volcano)
plot_ly(z = ~volcano, type = "surface")

# plotly has a functional interface: every plotly function takes a plotly
# object as it's first input argument and returns a modified plotly object
add_lines(plot_ly(economics, x = ~date, y = ~unemploy/pop))

# To make code more readable, plotly imports the pipe operator from magrittr
economics \%>\% plot_ly(x = ~date, y = ~unemploy/pop) \%>\% add_lines()

# Attributes defined via plot_ly() set 'global' attributes that 
# are carried onto subsequent traces, but those may be over-written
plot_ly(economics, x = ~date, color = I("black")) \%>\%
 add_lines(y = ~uempmed) \%>\%
 add_lines(y = ~psavert, color = I("red"))

# Attributes are documented in the figure reference -> https://plot.ly/r/reference
# You might notice plot_ly() has named arguments that aren't in this figure
# reference. These arguments make it easier to map abstract data values to
# visual attributes.
p <- plot_ly(iris, x = ~Sepal.Width, y = ~Sepal.Length) 
add_markers(p, color = ~Petal.Length, size = ~Petal.Length)
add_markers(p, color = ~Species)
add_markers(p, color = ~Species, colors = "Set1")
add_markers(p, symbol = ~Species)
add_paths(p, linetype = ~Species)

}

}
\seealso{
\itemize{
\item For initializing a plotly-geo object: \code{\link[=plot_geo]{plot_geo()}}.
\item For initializing a plotly-mapbox object: \code{\link[=plot_mapbox]{plot_mapbox()}}.
\item For translating a ggplot2 object to a plotly object: \code{\link[=ggplotly]{ggplotly()}}.
\item For modifying any plotly object: \code{\link[=layout]{layout()}}, \code{\link[=add_trace]{add_trace()}}, \code{\link[=style]{style()}}
\item
}
}
\author{
Carson Sievert
}
