% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restore.R
\name{restore}
\alias{restore}
\title{Restore project library from a lockfile}
\usage{
restore(
  project = NULL,
  ...,
  library = NULL,
  lockfile = NULL,
  packages = NULL,
  exclude = NULL,
  rebuild = FALSE,
  repos = NULL,
  clean = FALSE,
  prompt = interactive()
)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, renv will signal an error.}

\item{library}{The library paths to be used during restore. See \strong{Library}
for details.}

\item{lockfile}{Path to a lockfile. When \code{NULL} (the default), the
\code{renv.lock} located in the root of the current project will be used.}

\item{packages}{A subset of packages recorded in the lockfile to restore.
When \code{NULL} (the default), all packages available in the lockfile will be
restored. Any required recursive dependencies of the requested packages
will be restored as well.}

\item{exclude}{A subset of packages to be excluded during restore. This can
be useful for when you'd like to restore all but a subset of packages from
a lockfile. Note that if you attempt to exclude a package which is required
as the recursive dependency of another package, your request will be
ignored.}

\item{rebuild}{Force packages to be rebuilt, thereby bypassing any installed
versions of the package available in the cache? This can either be a
boolean (indicating that all installed packages should be rebuilt), or a
vector of package names indicating which packages should be rebuilt.}

\item{repos}{The repositories to use when restoring packages installed
from CRAN or a CRAN-like repository. By default, the repositories recorded
in the lockfile will be, ensuring that (e.g.) CRAN packages are
re-installed from the same CRAN mirror.

Use \code{repos = getOptions(repos)} to override with the repositories set
in the current session, or see the \code{repos.override} option in \link{config} for
an alternate way override.}

\item{clean}{Boolean; remove packages not recorded in the lockfile from
the target library? Use \code{clean = TRUE} if you'd like the library state
to exactly reflect the lockfile contents after \code{restore()}.}

\item{prompt}{Boolean; prompt the user before taking any action? For backwards
compatibility, \code{confirm} is accepted as an alias for \code{prompt}.}
}
\value{
A named list of package records which were installed by renv.
}
\description{
Restore a project's dependencies from a lockfile, as previously generated by
\code{\link[=snapshot]{snapshot()}}. \code{renv::restore()} compares packages recorded in the lockfile to
the packages installed in the project library. Where there are differences
it resolves them by installing the lockfile-recorded package into the
project library. If \code{clean = TRUE}, \code{restore()} will additionally delete any
packages in the project library that don't appear in the lockfile.
}
\examples{

\dontrun{

# disable automatic snapshots
auto.snapshot <- getOption("renv.config.auto.snapshot")
options(renv.config.auto.snapshot = FALSE)

# initialize a new project (with an empty R library)
renv::init(bare = TRUE)

# install digest 0.6.19
renv::install("digest@0.6.19")

# save library state to lockfile
renv::snapshot()

# remove digest from library
renv::remove("digest")

# check library status
renv::status()

# restore lockfile, thereby reinstalling digest 0.6.19
renv::restore()

# restore automatic snapshots
options(renv.config.auto.snapshot = auto.snapshot)

}
}
\seealso{
Other reproducibility: 
\code{\link{lockfiles}},
\code{\link{snapshot}()}
}
\concept{reproducibility}
