% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhandsontable.R
\name{hot_validate_numeric}
\alias{hot_validate_numeric}
\title{Handsontable widget}
\usage{
hot_validate_numeric(hot, cols, min = NULL, max = NULL, choices = NULL,
  exclude = NULL, allowInvalid = FALSE)
}
\arguments{
\item{hot}{rhandsontable object}

\item{cols}{vector of column names or indices}

\item{min}{minimum value to accept}

\item{max}{maximum value to accept}

\item{choices}{a vector of acceptable numeric choices. It will be evaluated
after min and max if specified.}

\item{exclude}{a vector of unacceptable numeric values}

\item{allowInvalid}{logical specifying whether invalid data will be
accepted. Invalid data cells will be color red.}
}
\description{
Add numeric validation to a column
}
\examples{
library(rhandsontable)
MAT = matrix(rnorm(50), nrow = 10, dimnames = list(LETTERS[1:10],
             letters[1:5]))

rhandsontable(MAT * 10) \%>\%
  hot_validate_numeric(col = 1, min = -50, max = 50, exclude = 40)

rhandsontable(MAT * 10) \%>\%
  hot_validate_numeric(col = 1, choices = c(10, 20, 40))
}
\seealso{
\code{\link{hot_validate_character}}
}
