% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitr.R
\name{divide_chunk}
\alias{divide_chunk}
\title{Divide chunk options from the code chunk body}
\usage{
divide_chunk(engine, code, strict = FALSE, ...)
}
\arguments{
\item{engine}{The name of the language engine (to determine the appropriate
comment character).}

\item{code}{A character vector (lines of code).}

\item{strict}{If \code{FALSE}, allow chunk options to be written after \verb{#|} even
if \verb{#} is not the comment character of the engine (e.g., when \code{engine = 'js'}), otherwise throw an error if \verb{#|} is detected but \verb{#} is not the
comment character.}

\item{...}{Arguments to be passed to \code{\link[=yaml_load]{yaml_load()}}.}
}
\value{
A list with the following items:
\itemize{
\item \code{options}: The parsed options (if there are any) as a list.
\item \code{src}: The part of the input that contains the options.
\item \code{code}: The part of the input that contains the code.
}
}
\description{
Chunk options can be written in special comments (e.g., after \verb{#|} for R code
chunks) inside a code chunk. This function partitions these options from the
chunk body.
}
\note{
Chunk options must be written on \emph{continuous} lines (i.e., all lines
must start with the special comment prefix such as \verb{#|}) at the beginning
of the chunk body.
}
\examples{
# parse yaml-like items
yaml_like = c("#| label: mine", "#| echo: true", "#| fig.width: 8", "#| foo: bar",
    "1 + 1")
writeLines(yaml_like)
xfun::divide_chunk("r", yaml_like)

# parse CSV syntax
csv_like = c("#| mine, echo = TRUE, fig.width = 8, foo = 'bar'", "1 + 1")
writeLines(csv_like)
xfun::divide_chunk("r", csv_like)
}
