/***********************************************************************

RADIUS
Remote Authentication Dial In User Service

Lucent Technologies Remote Access
4464 Willow Road
Pleasanton, CA   94588

Copyright 1992-1999 Lucent Technologies Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

   * Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.

   * All advertising materials mentioning features or use of this
     software must display the following acknowledgement:

	  This product includes software developed by Lucent
	  Technologies and its contributors.

   * Neither the name of the copyright holder nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

This software is provided by the copyright holders and contributors
``as is'' and any express or implied warranties, including, but not
limited to, the implied warranties of merchantability and fitness for a
particular purpose are disclaimed. In no event shall the copyright
holder or contributors be liable for any direct, indirect, incidental,
special, exemplary, or consequential damages (including, but not
limited to, procurement of substitute goods or services; loss of use,
data, or profits; or business interruption) however caused and on any
theory of liability, whether in contract, strict liability, or tort
(including negligence or otherwise) arising in any way out of the use
of this software, even if advised of the possibility of such damage.

************************************************************************/

/*
 * $Id: vports.h,v 1.2 1999/06/23 23:40:45 cdr Exp $ Copyright 1998 Lucent Technologies, Inc.
 */

#ifdef VPORTS

#define VP_LIST_INIT	0xff
#define VP_RET_IGNORE	0
#define VP_RET_REJECT	1
#define VP_RET_ACCEPT	2
#define VP_CACHE_EXPIRE	30	/* in seconds */

typedef struct vp_callcache
{
	time_t tm;
	struct vp_callcache *next;
	struct vp_callcache *prev;
} VP_CALLCACHE;

typedef struct vp_acctid
{
	char acctid[32];
	struct vp_acctid *next;
	struct vp_acctid *prev;
} VP_ACCTID;

typedef struct vp_nas
{
	UINT4	addr;
	u_char acctidinit;
	VP_ACCTID *acctid_first;
	VP_ACCTID *acctid_last;
	struct vp_nas *next;
	struct vp_nas *prev;
} VP_NAS;

typedef struct vp_called
{
	char num[16];
	u_int max;
	u_char nasipinit;
	u_char callcacheinit;
	VP_NAS *nasip_first;
	VP_NAS *nasip_last;
	VP_CALLCACHE *cc_first;
	VP_CALLCACHE *cc_last;
	struct vp_called *next;
	struct vp_called *prev;
} VP_CALLED;

int vports_init();
VP_CALLED *begin_cidlist();
VP_CALLED  *new_cidlist();
VP_CALLED *get_cidlist(u_char *num);
void create_cidlist(u_char *num, int max);
int vports_in_use(VP_CALLED *cidcur);
int vports_in_cache(VP_CALLED *cidcur);
VP_CALLCACHE *begin_cclist(VP_CALLED *cidcur);
void free_single_cclist(VP_CALLED *cidcur, VP_CALLCACHE *cc_cur);
VP_CALLCACHE *new_cclist(VP_CALLED *cidcur);
VP_NAS *begin_nasiplist(VP_CALLED *cidcur);
void free_single_nasiplist(VP_CALLED *cidcur, VP_NAS *nasip_cur);
VP_NAS *get_nasiplist(VP_CALLED *cidcur, UINT4 addr);
VP_NAS *new_nasiplist(VP_CALLED *cidcur, UINT4 addr);
VP_ACCTID *begin_acctidlist(VP_NAS *nasip_cur);
void free_single_acctidlist(VP_NAS *nasip_cur, VP_ACCTID *acctid_cur);
VP_ACCTID *get_acctidlist(VP_NAS *nasip_cur, u_char *acctid);
VP_ACCTID *new_acctidlist(VP_NAS *nasip_cur, u_char *acctid);
int vp_check_req(AUTH_REQ *authreq);
void vp_update_cid(AUTH_REQ *authreq);

VP_CALLED	*cidfirst;
VP_CALLED	*cidlast;
u_char		vp_cidinit;


#endif /* VPORTS */
