#!/bin/sh
#
# Copyright (c) 2022  Peter Pentchev <roam@ringlet.net>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

set -e

usage()
{
	cat <<'EOUSAGE'
Usage:	remrun-prepare.sh apt|yum /path/to/requirements.txt
EOUSAGE
}

if [ ! -f "$2" ]; then
	usage 1>&2
	exit 1
fi

case "$1" in
	apt)
		[ -n "$SKIP_APT_UPDATE" ] || apt-get update

		env DEBIAN_FRONTEND=noninteractive apt-get install -y python3 python3-venv openssh-client openssh-server
		;;

	yum)
		yum -y install python39 openssh openssh-clients openssh-server
		;;

	*)
		usage 1>&2
		exit 1
		;;
esac

vdir="/opt/remrun-venv-run-sshd-test"
vpy="$vdir/bin/python3"

python3 -m venv -- "$vdir"

installed="$("$vpy" -m pip list --format freeze | cut -d= -f1)"
# shellcheck disable=SC2086
"$vpy" -m pip install -U -- $installed

"$vpy" -m pip install -r "$2"
