/*
*  RAL -- Rubrica Addressbook Library
*  file: load.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _RUBRICA_LOAD_H
#define _R_LOAD_H


#include <glib.h>
#include <libxml/tree.h>

#include "../../card.h"
#include "../../personal.h"
#include "../../company.h"
//#include "../../group_box.h"
#include "../../error.h"

xmlDocPtr  r_open_doc          (gchar* filename, RError* err);

gint       r_get_fileformat    (xmlDocPtr xdoc, RError* err);
gchar*     r_get_version       (xmlDocPtr xdoc, RError* err);
gchar*     r_get_document_tpye (xmlDocPtr xdoc, RError* err);
gboolean   r_is_rubrica_doc    (xmlDocPtr xdoc, RError* err);


RPersonalCard* r_read_personal_xmlcard (xmlNodePtr xmlcard);
RCompanyCard*  r_read_company_xmlcard  (xmlNodePtr xmlcard); 

RPersonalCard* r_read_old_personal_xmlcard (xmlNodePtr xmlcard);


void       r_read_infos          (RCard *card, xmlNodePtr node);
void       r_read_groups         (RCard *card, xmlNodePtr node);
void       r_read_refs           (RCard *card, xmlNodePtr node);
void       r_read_addresses      (RCard *card, xmlNodePtr node);
void       r_read_net            (RCard *card, xmlNodePtr node);
void       r_read_telephone      (RCard *card, xmlNodePtr node);

void       r_read_contact        (RPersonalCard *card, xmlNodePtr node);
void       r_read_work           (RPersonalCard *card, xmlNodePtr node);
void       r_read_notes          (RPersonalCard *card, xmlNodePtr node);

void       r_read_company        (RCompanyCard* card, xmlNodePtr node);
void       r_read_company_notes  (RCompanyCard* card, xmlNodePtr node);

// RGroupSet* r_read_get_user_group (void);

#endif
