#
# based on Dag Wieers <dag@wieers.com> rubrica.spec file
#

%define rel   1

Name:      rubrica2
Summary:   Rubrica, an address book for Gnome Environment.
Version:   2.0
Release:   %rel
License:   GPL
Group:     Applications/Productivity
Source:    http://download.berlios.de/rubrica/%{name}-%{version}.tar.bz2
URL:       http://rubrica.berlios.de
Vendor:    Nicola Fragale <nicolafragale@gmail.com>
Packager:  Nicola Fragale <nicolafragale@gmail.com>

BuildRoot: %{_tmppath}/root-%{name}-%{version}
Prefix:    %{_prefix}
Requires:   gtk2 >= 2.6, libglade2, libxml2
BuildRequires: gtk2-devel >= 2.6, libglade2-devel, libxml2-devel


%description
An address book for GNOME Environment. 

%prep
%setup

%build
%configure \
	--disable-install-schemas \
	--enable-nls
%{__make} %{?_smp_mflags}

%install
%{__rm} -rf %{buildroot}
export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL="1"
%makeinstall
%find_lang %{name}

%{__rm} -rf %{buildroot}%{_docdir}/rubrica2

%post
export GCONF_CONFIG_SOURCE="$(gconftool-2 --get-default-source)"
gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/%{name}.schemas &>/dev/null
scrollkeeper-update -q

%postun
scrollkeeper-update -q

%clean
%{__rm} -rf %{buildroot}


%files -f %{name}.lang 
%defattr(-, root, root, 0755)
%doc README ChangeLog COPYING AUTHORS NEWS TODO CREDITS
%config %{_sysconfdir}/gconf/schemas/*.schemas
%{_bindir}/*
%{_libdir}/libral.*
%{_libdir}/libral/plugins/*
%{_datadir}/rubrica2/interface/
%{_datadir}/icons/hicolor/*
%{_datadir}/applications/*.desktop
%{_datadir}/mime-info/*
%exclude %{_datadir}/icons/hicolor/icon-theme.cache
%exclude %{_libdir}/*.a
%exclude %{_libdir}/*.la
%exclude %{_libdir}/libral/plugins/*.?a
%exclude %{_libdir}/libral/plugins/*.la


