import QtQuick 2.12
import org.ukui.windowThumbnail 1.0

Item {
    id: thumbnailSourceItem
    clip: true

    property var winId
    property string desktopEntry: ""
    property alias thumbnailMprisModel: mprisModel

    WindowThumbnailMprisModel {
        id: mprisModel
        winID: thumbnailSourceItem.winId
    }

    Loader {
        id: thumbnailLoader
        anchors.fill: parent
        visible: windowThumbnailConfig.realTimeThumbnailEnable
        sourceComponent: {
            if (mprisModel.count > 0) {
                return mprisPlayerComponent;
            } else {
                 if (windowThumbnailConfig.pipewireThumbnailEnable) {
                     return piperWireThumbnailComponent;
                 } else {
                    return x11ThumbnailComponent;
                 }
            }
        }

        Component {
            id: x11ThumbnailComponent
            XWindowThumbnail {
                winId: thumbnailSourceItem.winId
            }
        }
         Component {
             id: piperWireThumbnailComponent
             PipeWireThumbnail { }
         }
        Component {
            id: mprisPlayerComponent
            MprisPlayerThumbnail { }
        }
    }
}
