/*
 * Copyright 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "devpowercontrol.h"

DevPowerControl::DevPowerControl(QObject *parent) : QObject(parent)
{
    UpmPreprocessor upp;

    if (upp.pciEnable()) {
        m_pci = new PciDevice(this);
    }

    if (upp.i2cEnable()) {
        m_i2c = new I2cDevice(this);
    }

    if (upp.sataEnable()) {
        m_sata = new SataDevice(this);
    }
}

DevPowerControl::~DevPowerControl() {}

void DevPowerControl::setAllDevicePerformance()
{
    setAllDevice("on");
}

void DevPowerControl::setAllDeviceBalance()
{
    setAllDevice("default");
}

void DevPowerControl::setAllDeviceSave()
{
    setAllDevice("auto");
}

void DevPowerControl::setAllDevice(QString mode)
{
    if (m_pci != nullptr) {
        m_pci->setAllDevicePowerStat(mode);
    }

    if (m_i2c != nullptr) {
        m_i2c->setAllDevicePowerStat(mode);
    }

    if (m_sata != nullptr) {
        if (mode == "on") {
            m_sata->setAllDevicePowerStat("max_performance");
        } else if (mode == "auto") {
            m_sata->setAllDevicePowerStat("min_power");
        } else {
            m_sata->setAllDevicePowerStat(mode);
        }
    }
}
