#!/bin/bash
#
# Copyright (c) 2020, Oracle and/or its affiliates. All rights reserved.
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
#
# This code is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 only, as
# published by the Free Software Foundation.
#
# This code is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# version 2 for more details (a copy is included in the LICENSE file that
# accompanied this code).
#
# You should have received a copy of the GNU General Public License version
# 2 along with this work; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
# or visit www.oracle.com if you need additional information or have any
# questions.
#

# Arguments passed to us from makefile.
AUTOCONF="$1"
TOPDIR="$2"
TEST_SUPPORT_DIR="$3"

mkdir -p $TEST_SUPPORT_DIR/test-conf
cd $TEST_SUPPORT_DIR/test-conf

conf_script_dir="$TOPDIR/make/autoconf"
generated_script="$TEST_SUPPORT_DIR/generated-test-configure.sh"

# Generate configure script with test hooks compiled in.
echo "Generating test-configure script at $generated_script"
cat $conf_script_dir/configure.ac |
    sed -e "s|#CUSTOM_AUTOCONF_INCLUDE|m4_include([test.m4])|" | \
    ${AUTOCONF} -W all -I$TOPDIR/test/make/autoconf -I$conf_script_dir - \
    > $generated_script
rm -rf autom4te.cache

# Sanity check
if test ! -s $generated_script; then
  echo "Error: Failed to generate test-configure script" 1>&2
  rm -f $generated_script
  exit 1
fi

# Make sure all shell commands are executed with the C locale
export LC_ALL=C

# Export our null command line
CONFIGURE_COMMAND_LINE=""

# Force autoconf to use bash. This also means we must disable autoconf re-exec.
export CONFIG_SHELL=$BASH
export _as_can_reexec=no

# Now transfer control to the script generated by autoconf. This is where the
# main work is done.

RCDIR=`mktemp -dt jdk-build-configure.tmp.XXXXXX` || exit $?
trap "rm -rf \"$RCDIR\"" EXIT
conf_logfile=./configure.log
(exec 3>&1 ; ((. $generated_script --enable-option-checking=fatal 2>&1 1>&3 ) \
    ; echo $? > "$RCDIR/rc" ) \
    | tee -a $conf_logfile 1>&2 ; exec 3>&-) | tee -a $conf_logfile

conf_result_code=`cat "$RCDIR/rc"`

if test $conf_result_code -ne 0; then
  echo "=============================="
  echo "Configure tests finished with failure. Result code: $conf_result_code"
fi

exit $conf_result_code
