#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Wish Upon a Star
# send your bug reports to contact@dotslashplay.it
###

script_version=20241130.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='a-wish-upon-a-star'
GAME_NAME='A Wish Upon a Star'

ARCHIVE_BASE_64BIT_0_NAME='AWishUponAStar_WIN_v1_2_0.zip'
ARCHIVE_BASE_64BIT_0_MD5='1c76b283aabf5d64bc05fbf489cf3a25'
ARCHIVE_BASE_64BIT_0_SIZE='260000'
ARCHIVE_BASE_64BIT_0_VERSION='1.2.0-itch.2018.07.07'
ARCHIVE_BASE_64BIT_0_URL='https://fabiandenter.itch.io/wish-upon-a-star'

ARCHIVE_BASE_32BIT_0_NAME='AWishUponAStar_v1_2_0_WIN32.zip'
ARCHIVE_BASE_32BIT_0_MD5='6644015a399d7485f7c73491f9462854'
ARCHIVE_BASE_32BIT_0_SIZE='260000'
ARCHIVE_BASE_32BIT_0_VERSION='1.2.0-itch.2018.07.07'
ARCHIVE_BASE_32BIT_0_URL='https://fabiandenter.itch.io/wish-upon-a-star'

UNITY3D_NAME='AWishUponAStar'

CONTENT_PATH_DEFAULT_64BIT='AWishUponAStar_WIN_v1_2_0'
CONTENT_PATH_DEFAULT_32BIT='AWishUponAStar_v1_2_0_WIN32'

WINE_REGEDIT_PERSISTENT_KEYS='
HKEY_CURRENT_USER\Software\Fabian Denter\A Wish Upon A Star'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH_32BIT='32'
PKG_BIN_ARCH_64BIT='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
