// Copyright © SixtyFPS GmbH <info@slint.dev>
// SPDX-License-Identifier: GPL-3.0-only OR LicenseRef-Slint-Royalty-free-2.0 OR LicenseRef-Slint-Software-3.0

use std::collections::HashMap;

use crate::literals::parse_color_literal;

static NAMED_COLORS: std::sync::OnceLock<HashMap<&'static str, u32>> = std::sync::OnceLock::new();

pub fn named_colors() -> &'static HashMap<&'static str, u32> {
    // Colors from https://drafts.csswg.org/css-color/#named-colors plus "transparent"
    NAMED_COLORS.get_or_init(|| {
        HashMap::from([
            ("aliceblue", parse_color_literal("#F0F8FF").unwrap()),
            ("antiquewhite", parse_color_literal("#FAEBD7").unwrap()),
            ("aqua", parse_color_literal("#00FFFF").unwrap()),
            ("aquamarine", parse_color_literal("#7FFFD4").unwrap()),
            ("azure", parse_color_literal("#F0FFFF").unwrap()),
            ("beige", parse_color_literal("#F5F5DC").unwrap()),
            ("bisque", parse_color_literal("#FFE4C4").unwrap()),
            ("black", parse_color_literal("#000000").unwrap()),
            ("blanchedalmond", parse_color_literal("#FFEBCD").unwrap()),
            ("blue", parse_color_literal("#0000FF").unwrap()),
            ("blueviolet", parse_color_literal("#8A2BE2").unwrap()),
            ("brown", parse_color_literal("#A52A2A").unwrap()),
            ("burlywood", parse_color_literal("#DEB887").unwrap()),
            ("cadetblue", parse_color_literal("#5F9EA0").unwrap()),
            ("chartreuse", parse_color_literal("#7FFF00").unwrap()),
            ("chocolate", parse_color_literal("#D2691E").unwrap()),
            ("coral", parse_color_literal("#FF7F50").unwrap()),
            ("cornflowerblue", parse_color_literal("#6495ED").unwrap()),
            ("cornsilk", parse_color_literal("#FFF8DC").unwrap()),
            ("crimson", parse_color_literal("#DC143C").unwrap()),
            ("cyan", parse_color_literal("#00FFFF").unwrap()),
            ("darkblue", parse_color_literal("#00008B").unwrap()),
            ("darkcyan", parse_color_literal("#008B8B").unwrap()),
            ("darkgoldenrod", parse_color_literal("#B8860B").unwrap()),
            ("darkgray", parse_color_literal("#A9A9A9").unwrap()),
            ("darkgreen", parse_color_literal("#006400").unwrap()),
            ("darkgrey", parse_color_literal("#A9A9A9").unwrap()),
            ("darkkhaki", parse_color_literal("#BDB76B").unwrap()),
            ("darkmagenta", parse_color_literal("#8B008B").unwrap()),
            ("darkolivegreen", parse_color_literal("#556B2F").unwrap()),
            ("darkorange", parse_color_literal("#FF8C00").unwrap()),
            ("darkorchid", parse_color_literal("#9932CC").unwrap()),
            ("darkred", parse_color_literal("#8B0000").unwrap()),
            ("darksalmon", parse_color_literal("#E9967A").unwrap()),
            ("darkseagreen", parse_color_literal("#8FBC8F").unwrap()),
            ("darkslateblue", parse_color_literal("#483D8B").unwrap()),
            ("darkslategray", parse_color_literal("#2F4F4F").unwrap()),
            ("darkslategrey", parse_color_literal("#2F4F4F").unwrap()),
            ("darkturquoise", parse_color_literal("#00CED1").unwrap()),
            ("darkviolet", parse_color_literal("#9400D3").unwrap()),
            ("deeppink", parse_color_literal("#FF1493").unwrap()),
            ("deepskyblue", parse_color_literal("#00BFFF").unwrap()),
            ("dimgray", parse_color_literal("#696969").unwrap()),
            ("dimgrey", parse_color_literal("#696969").unwrap()),
            ("dodgerblue", parse_color_literal("#1E90FF").unwrap()),
            ("firebrick", parse_color_literal("#B22222").unwrap()),
            ("floralwhite", parse_color_literal("#FFFAF0").unwrap()),
            ("forestgreen", parse_color_literal("#228B22").unwrap()),
            ("fuchsia", parse_color_literal("#FF00FF").unwrap()),
            ("gainsboro", parse_color_literal("#DCDCDC").unwrap()),
            ("ghostwhite", parse_color_literal("#F8F8FF").unwrap()),
            ("gold", parse_color_literal("#FFD700").unwrap()),
            ("goldenrod", parse_color_literal("#DAA520").unwrap()),
            ("gray", parse_color_literal("#808080").unwrap()),
            ("green", parse_color_literal("#008000").unwrap()),
            ("greenyellow", parse_color_literal("#ADFF2F").unwrap()),
            ("grey", parse_color_literal("#808080").unwrap()),
            ("honeydew", parse_color_literal("#F0FFF0").unwrap()),
            ("hotpink", parse_color_literal("#FF69B4").unwrap()),
            ("indianred", parse_color_literal("#CD5C5C").unwrap()),
            ("indigo", parse_color_literal("#4B0082").unwrap()),
            ("ivory", parse_color_literal("#FFFFF0").unwrap()),
            ("khaki", parse_color_literal("#F0E68C").unwrap()),
            ("lavender", parse_color_literal("#E6E6FA").unwrap()),
            ("lavenderblush", parse_color_literal("#FFF0F5").unwrap()),
            ("lawngreen", parse_color_literal("#7CFC00").unwrap()),
            ("lemonchiffon", parse_color_literal("#FFFACD").unwrap()),
            ("lightblue", parse_color_literal("#ADD8E6").unwrap()),
            ("lightcoral", parse_color_literal("#F08080").unwrap()),
            ("lightcyan", parse_color_literal("#E0FFFF").unwrap()),
            ("lightgoldenrodyellow", parse_color_literal("#FAFAD2").unwrap()),
            ("lightgray", parse_color_literal("#D3D3D3").unwrap()),
            ("lightgreen", parse_color_literal("#90EE90").unwrap()),
            ("lightgrey", parse_color_literal("#D3D3D3").unwrap()),
            ("lightpink", parse_color_literal("#FFB6C1").unwrap()),
            ("lightsalmon", parse_color_literal("#FFA07A").unwrap()),
            ("lightseagreen", parse_color_literal("#20B2AA").unwrap()),
            ("lightskyblue", parse_color_literal("#87CEFA").unwrap()),
            ("lightslategray", parse_color_literal("#778899").unwrap()),
            ("lightslategrey", parse_color_literal("#778899").unwrap()),
            ("lightsteelblue", parse_color_literal("#B0C4DE").unwrap()),
            ("lightyellow", parse_color_literal("#FFFFE0").unwrap()),
            ("lime", parse_color_literal("#00FF00").unwrap()),
            ("limegreen", parse_color_literal("#32CD32").unwrap()),
            ("linen", parse_color_literal("#FAF0E6").unwrap()),
            ("magenta", parse_color_literal("#FF00FF").unwrap()),
            ("maroon", parse_color_literal("#800000").unwrap()),
            ("mediumaquamarine", parse_color_literal("#66CDAA").unwrap()),
            ("mediumblue", parse_color_literal("#0000CD").unwrap()),
            ("mediumorchid", parse_color_literal("#BA55D3").unwrap()),
            ("mediumpurple", parse_color_literal("#9370DB").unwrap()),
            ("mediumseagreen", parse_color_literal("#3CB371").unwrap()),
            ("mediumslateblue", parse_color_literal("#7B68EE").unwrap()),
            ("mediumspringgreen", parse_color_literal("#00FA9A").unwrap()),
            ("mediumturquoise", parse_color_literal("#48D1CC").unwrap()),
            ("mediumvioletred", parse_color_literal("#C71585").unwrap()),
            ("midnightblue", parse_color_literal("#191970").unwrap()),
            ("mintcream", parse_color_literal("#F5FFFA").unwrap()),
            ("mistyrose", parse_color_literal("#FFE4E1").unwrap()),
            ("moccasin", parse_color_literal("#FFE4B5").unwrap()),
            ("navajowhite", parse_color_literal("#FFDEAD").unwrap()),
            ("navy", parse_color_literal("#000080").unwrap()),
            ("oldlace", parse_color_literal("#FDF5E6").unwrap()),
            ("olive", parse_color_literal("#808000").unwrap()),
            ("olivedrab", parse_color_literal("#6B8E23").unwrap()),
            ("orange", parse_color_literal("#FFA500").unwrap()),
            ("orangered", parse_color_literal("#FF4500").unwrap()),
            ("orchid", parse_color_literal("#DA70D6").unwrap()),
            ("palegoldenrod", parse_color_literal("#EEE8AA").unwrap()),
            ("palegreen", parse_color_literal("#98FB98").unwrap()),
            ("paleturquoise", parse_color_literal("#AFEEEE").unwrap()),
            ("palevioletred", parse_color_literal("#DB7093").unwrap()),
            ("papayawhip", parse_color_literal("#FFEFD5").unwrap()),
            ("peachpuff", parse_color_literal("#FFDAB9").unwrap()),
            ("peru", parse_color_literal("#CD853F").unwrap()),
            ("pink", parse_color_literal("#FFC0CB").unwrap()),
            ("plum", parse_color_literal("#DDA0DD").unwrap()),
            ("powderblue", parse_color_literal("#B0E0E6").unwrap()),
            ("purple", parse_color_literal("#800080").unwrap()),
            ("rebeccapurple", parse_color_literal("#663399").unwrap()),
            ("red", parse_color_literal("#FF0000").unwrap()),
            ("rosybrown", parse_color_literal("#BC8F8F").unwrap()),
            ("royalblue", parse_color_literal("#4169E1").unwrap()),
            ("saddlebrown", parse_color_literal("#8B4513").unwrap()),
            ("salmon", parse_color_literal("#FA8072").unwrap()),
            ("sandybrown", parse_color_literal("#F4A460").unwrap()),
            ("seagreen", parse_color_literal("#2E8B57").unwrap()),
            ("seashell", parse_color_literal("#FFF5EE").unwrap()),
            ("sienna", parse_color_literal("#A0522D").unwrap()),
            ("silver", parse_color_literal("#C0C0C0").unwrap()),
            ("skyblue", parse_color_literal("#87CEEB").unwrap()),
            ("slateblue", parse_color_literal("#6A5ACD").unwrap()),
            ("slategray", parse_color_literal("#708090").unwrap()),
            ("slategrey", parse_color_literal("#708090").unwrap()),
            ("snow", parse_color_literal("#FFFAFA").unwrap()),
            ("springgreen", parse_color_literal("#00FF7F").unwrap()),
            ("steelblue", parse_color_literal("#4682B4").unwrap()),
            ("tan", parse_color_literal("#D2B48C").unwrap()),
            ("teal", parse_color_literal("#008080").unwrap()),
            ("thistle", parse_color_literal("#D8BFD8").unwrap()),
            ("tomato", parse_color_literal("#FF6347").unwrap()),
            ("transparent", parse_color_literal("#00000000").unwrap()),
            ("turquoise", parse_color_literal("#40E0D0").unwrap()),
            ("violet", parse_color_literal("#EE82EE").unwrap()),
            ("wheat", parse_color_literal("#F5DEB3").unwrap()),
            ("white", parse_color_literal("#FFFFFF").unwrap()),
            ("whitesmoke", parse_color_literal("#F5F5F5").unwrap()),
            ("yellow", parse_color_literal("#FFFF00").unwrap()),
            ("yellowgreen", parse_color_literal("#9ACD32").unwrap()),
        ])
    })
}
