/**
 * Copyright (c) 2016-2025 Governikus GmbH & Co. KG, Germany
 */

#pragma once

#include "Env.h"
#include "SingletonCreator.h"

#include <QAbstractListModel>
#include <QList>
#include <QString>
#include <QtQml/qqmlregistration.h>

#include <utility>


namespace governikus
{

class VersionInformationModel
	: public QAbstractListModel
	, public SingletonCreator<VersionInformationModel>
{
	Q_OBJECT
	QML_ELEMENT
	QML_SINGLETON

	friend class Env;

	private:
		enum VersionRoles
		{
			KEY = Qt::UserRole + 1,
			VALUE
		};
		QList<std::pair<QString, QString>> mData;

		VersionInformationModel();
		~VersionInformationModel() override = default;

		void init();

	public:
		[[nodiscard]] int rowCount(const QModelIndex&) const override;
		[[nodiscard]] QVariant data(const QModelIndex& pIndex, int pRole = Qt::DisplayRole) const override;
		[[nodiscard]] QHash<int, QByteArray> roleNames() const override;
};

} // namespace governikus
