/* set.h	8/19/1995
 */

/* SPDX-FileCopyrightText: 1995,1996 Sascha Demetrio
 * SPDX-FileCopyrightText: 2009, 2015 Peter Pentchev
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _SET_H_
#define _SET_H_

enum s_option_e { S_STRING = 1, S_INTEGER, S_BOOL };

#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wstrict-prototypes"
#endif
typedef void (*set_fn)();
#ifdef __GNUC__
#pragma GCC diagnostic error "-Wstrict-prototypes"
#endif

long
s_get_option_integer(const char *option);

const char *
s_get_option_string(const char *option);

int
s_get_option_bool(const char *option);

enum s_option_e
s_get_type(const char *option);

const char *
s_get_option(const char *option);

int
s_delete_option(const char *option);

void
s_set_option_string(const char *option, const char *value);

void
s_set_option_integer(const char *option, const long value);

void
s_set_option_bool(const char *option, const int value);

void
s_set_type(const char *option, const enum s_option_e type);

void
s_set_option(const char *option, const char *value_string,
                 int no_action);

void
s_set_action(const char *option, set_fn action);

char **
s_option_list(const char *prefix, int bool_only);

char **
s_option_value_list(void);

void
s_clear_all(void);

#endif

/* end of set.h */


/* VIM configuration: (do not delete this line)
 *
 * vim:bk:nodg:efm=%f\:%l\:%m:hid:icon:
 * vim:sw=2:sm:textwidth=79:ul=1024:wrap:
 */
