# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.paloaltonetworksngfw import PaloAltoNetworksNgfwMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPaloAltoNetworksNgfwMgmtFqdnListLocalRulestackOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PaloAltoNetworksNgfwMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fqdn_list_local_rulestack_list_by_local_rulestacks(self, resource_group):
        response = self.client.fqdn_list_local_rulestack.list_by_local_rulestacks(
            resource_group_name=resource_group.name,
            local_rulestack_name="str",
            api_version="2025-10-08",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fqdn_list_local_rulestack_get(self, resource_group):
        response = self.client.fqdn_list_local_rulestack.get(
            resource_group_name=resource_group.name,
            local_rulestack_name="str",
            name="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fqdn_list_local_rulestack_begin_create_or_update(self, resource_group):
        response = self.client.fqdn_list_local_rulestack.begin_create_or_update(
            resource_group_name=resource_group.name,
            local_rulestack_name="str",
            name="str",
            resource={
                "fqdnList": ["str"],
                "auditComment": "str",
                "description": "str",
                "etag": "str",
                "id": "str",
                "name": "str",
                "provisioningState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-10-08",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_fqdn_list_local_rulestack_begin_delete(self, resource_group):
        response = self.client.fqdn_list_local_rulestack.begin_delete(
            resource_group_name=resource_group.name,
            local_rulestack_name="str",
            name="str",
            api_version="2025-10-08",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
