% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cmd_list_keep_named}
\alias{cmd_list_keep_named}
\title{Keep items by name from list}
\usage{
cmd_list_keep_named(list, names)
}
\arguments{
\item{list}{an R list}

\item{names}{vector of names to keep}
}
\value{
list keeping only items defined by names
}
\description{
A pipe-friendly wrapper around \verb{list[(names(list) \%in\% names]}.
}
\details{
This function is slightly faster than using \code{\link[=cmd_list_keep]{cmd_list_keep()}} to keep items
by name.
}
\examples{
cmd_list_keep_named(list("a" = 1, "b" = 2), "a")
}
