% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnr.R
\name{glance.mnr}
\alias{glance.mnr}
\title{Glance at a \code{mnr} (maximum normed residual) object}
\usage{
\method{glance}{mnr}(x, ...)
}
\arguments{
\item{x}{An \code{mnr} object}

\item{...}{Additional arguments. Not used. Included only to match generic
signature.}
}
\value{
A one-row \code{\link[tibble:tibble]{tibble::tibble()}} with the following
columns:
\itemize{
\item \code{mnr} the computed MNR test statistic
\item \code{alpha} the value of alpha used for the test
\item \code{crit} the critical value given the sample size and the
significance level
\item \code{n_outliers} the number of outliers found
}
}
\description{
Glance accepts an object of type \code{mnr} and returns a
\code{\link[tibble:tibble]{tibble::tibble()}} with
one row of summaries.

Glance does not do any calculations: it just gathers the results in a
tibble.
}
\examples{
x <- c(rnorm(20, 100, 5), 10)
m <- maximum_normed_residual(x = x)
glance(m)

## # A tibble: 1 x 4
##     mnr alpha  crit n_outliers
##   <dbl> <dbl> <dbl>      <dbl>
## 1  4.23  0.05  2.73          1

}
\seealso{
\code{\link[=maximum_normed_residual]{maximum_normed_residual()}}
}
