% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string_operations.R
\name{col_substr}
\alias{col_substr}
\title{Substring(s) of an ANSI colored string}
\usage{
col_substr(x, start, stop)
}
\arguments{
\item{x}{Character vector, potentially ANSI styled, or a vector to
coarced to character.}

\item{start}{Starting index or indices, recycled to match the length
of \code{x}.}

\item{stop}{Ending index or indices, recycled to match the length
of \code{x}.}
}
\value{
Character vector of the same length as \code{x}, containing
the requested substrings. ANSI styles are retained.
}
\description{
This is a color-aware counterpart of \code{\link[base:substr]{base::substr()}}.
It works exactly like the original, but keeps the colors
in the substrings. The ANSI escape sequences are ignored when
calculating the positions within the string.
}
\examples{
str <- paste(
  red("red"),
  "default",
  green("green")
)

cat(str, "\n")
cat(col_substr(str, 1, 5), "\n")
cat(col_substr(str, 1, 15), "\n")
cat(col_substr(str, 3, 7), "\n")

substr(strip_style(str), 1, 5)
substr(strip_style(str), 1, 15)
substr(strip_style(str), 3, 7)

str2 <- "another " \%+\%
  red("multi-", sep = "", underline("style")) \%+\%
  " text"

cat(str2, "\n")
cat(col_substr(c(str, str2), c(3,5), c(7, 18)), sep = "\n")
substr(strip_style(c(str, str2)), c(3,5), c(7, 18))
}
\seealso{
Other ANSI string operations: 
\code{\link{col_align}()},
\code{\link{col_nchar}()},
\code{\link{col_strsplit}()},
\code{\link{col_substring}()}
}
\concept{ANSI string operations}
