% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{expand_scale}
\alias{expand_scale}
\title{Generate expansion vector for scales.}
\usage{
expand_scale(mult = 0, add = 0)
}
\arguments{
\item{mult}{vector of multiplicative range expansion factors.
If length 1, both the lower and upper limits of the scale
are expanded outwards by \code{mult}. If length 2, the lower limit
is expanded by \code{mult[1]} and the upper limit by \code{mult[2]}.}

\item{add}{vector of additive range expansion constants.
If length 1, both the lower and upper limits of the scale
are expanded outwards by \code{add} units. If length 2, the
lower limit is expanded by \code{add[1]} and the upper
limit by \code{add[2]}.}
}
\description{
This is a convenience function for generating scale expansion vectors
for the \code{expand} argument of
\code{\link[=scale_x_continuous]{scale_*_continuous}} and
\code{\link[=scale_x_discrete]{scale_*_discrete}}.
The expansions vectors are used to add some space between
the data and the axes.
}
\examples{
# No space below the bars but 10\% above them
ggplot(mtcars) +
  geom_bar(aes(x = factor(cyl))) +
  scale_y_continuous(expand = expand_scale(mult = c(0, .1)))

# Add 2 units of space on the left and right of the data
ggplot(subset(diamonds, carat > 2), aes(cut, clarity)) +
  geom_jitter() +
  scale_x_discrete(expand = expand_scale(add = 2))

# Reproduce the default range expansion used
# when the 'expand' argument is not specified
ggplot(subset(diamonds, carat > 2), aes(cut, price)) +
  geom_jitter() +
  scale_x_discrete(expand = expand_scale(add = .6)) +
  scale_y_continuous(expand = expand_scale(mult = .05))
}
