% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-options.R
\name{req_options}
\alias{req_options}
\title{Set arbitrary curl options in request}
\usage{
req_options(.req, ...)
}
\arguments{
\item{.req}{A \link{request}.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Name-value pairs. The name
should be a valid curl option, as found in \code{\link[curl:curl_options]{curl::curl_options()}}.}
}
\value{
A modified HTTP \link{request}.
}
\description{
\code{req_options()} is for expert use only; it allows you to directly set
libcurl options to access features that are otherwise not available in
httr2.
}
\examples{
# req_options() allows you to access curl options that are not otherwise
# exposed by httr2. For example, in very special cases you may need to
# turn off SSL verification. This is generally a bad idea so httr2 doesn't
# provide a convenient wrapper, but if you really know what you're doing
# you can still access this libcurl option:
req <- request("https://example.com") |>
  req_options(ssl_verifypeer = 0)
}
