% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-pc-hazard.R
\name{rchaz}
\alias{rchaz}
\alias{simrchaz}
\alias{addCums}
\alias{lin.approx}
\title{Simulation of Piecewise constant hazard model (Cox).}
\usage{
rchaz(
  cumhazard,
  rr,
  n = NULL,
  entry = NULL,
  cum.hazard = TRUE,
  cause = 1,
  extend = FALSE
)
}
\arguments{
\item{cumhazard}{cumulative hazard, or piece-constant rates for periods defined by first column of input.}

\item{rr}{relative risk for simulations, alternatively when rr=1 specify n}

\item{n}{number of simulation if rr not given}

\item{entry}{delayed entry time for simuations.}

\item{cum.hazard}{specifies wheter input is cumulative hazard or rates.}

\item{cause}{name of cause}

\item{extend}{to extend piecewise constant with constant rate. Default is average rate over time from cumulative (when TRUE), if numeric then uses given rate.}
}
\description{
Simulates data from piecwise constant baseline hazard that can also be of
Cox type. Censor data at highest value of the break points.
}
\details{
For a piecewise linear cumulative hazard the inverse is easy to compute with 
and delayed entry x we compute 
\deqn{\Lambda^{-1}(\Lambda(x) + E/RR)}, 
where RR are the relative risks and E is exponential with mean 1.
This quantity has survival function 
\deqn{P(T > t | T>x) = exp(-RR (\Lambda(t) - \Lambda(x)))}.
}
\examples{

chaz <-  c(0,1,1.5,2,2.1)
breaks <- c(0,10,   20,  30,   40)
cumhaz <- cbind(breaks,chaz)
n <- 100
X <- rbinom(n,1,0.5)
beta <- 0.2
rrcox <- exp(X * beta)

pctime <- rchaz(cumhaz,n=1000,cum.hazard=FALSE)
pctimecox <- rchaz(cumhaz,rrcox,cum.hazard=FALSE)

}
\author{
Thomas Scheike
}
\keyword{survival}
