#include <features.h>

int InhDur[ALL_END + 1] =
{
	240, 230, 140, 240, 260,	/* AA - AW */
	120, 260, 250, 150, 180,	/* AX - ER */
	270, 190, 135, 110, 230,	/* EXR - IXR */
	155, 220, 240, 280, 160,	/* IY - UH */
	210, 230, 230, 260, 80,		/* UW - HH */
	70, 100, 90, 80, 80,		/* HX - RX */
	100, 70, 80, 170, 170,		/* WW - EN */
	100, 110, 95, 80, 100,		/* MM - FF */
	105, 105, 90, 70, 100,		/* SS - ZZ */
	90, 50, 40, 40, 40,		/* ZH - GP */
	70, 70, 70, 45, 40,		/* KK - TT */
	75, 70, 70, 70			/* TQ - AXP */
};

int MinDur[ALL_END + 1] =
{
	100, 80, 60, 100, 100,	/* AA - AW */
	60, 120, 150, 70, 80,	/* AX - ER */
	130, 100, 40, 60, 80,	/* EXR - IXR */
	55, 80, 130, 150, 60,	/* IY - UH */
	70, 110, 150, 110, 20,	/* UW - HH */
	25, 40, 70, 30, 70,	/* HX - RX */
	60, 60, 40, 110, 100,	/* WW - EN */
	60, 50, 60, 50, 80,	/* MM - FF */
	60, 80, 60, 40, 60,	/* SS - ZZ */
	60, 60, 50, 20, 60,	/* ZH - GP */
	40, 40, 40, 50, 40,	/* KK - TT */
	50, 50, 50, 70,		/* TQ - AXP */
};

unsigned long Features[ALL_END + 1] =
{
	VOWEL | VOICE | SYLLA | SONOR | LOW,				/* AA */
	VOWEL | VOICE | SYLLA | SONOR | LOW | LAX | FRONT | DIPTH,	/* AE */
	VOWEL | VOICE | SYLLA | SONOR,					/* AH */
	VOWEL | VOICE | SYLLA | SONOR | LOW | ROUND | LAX | DIPTH,	/* AO */
	VOWEL | VOICE | SYLLA | SONOR | LOW | WGLID | DIPTH,		/* AW */
	VOWEL | VOICE | SYLLA | SONOR | SCHWA | LAX,			/* AX */
	VOWEL | VOICE | SYLLA | SONOR | LOW | RGLID | DIPTH,	       /* AXR */
	VOWEL | VOICE | SYLLA | SONOR | LOW | YGLID | DIPTH,		/* AY */
	VOWEL | VOICE | SYLLA | SONOR | FRONT | DIPTH,			/* EH */
	VOWEL | VOICE | SYLLA | SONOR | RETRO,				/* ER */
	VOWEL | VOICE | SYLLA | SONOR | RGLID | FRONT | DIPTH,	       /* EXR */
	VOWEL | VOICE | SYLLA | SONOR | YGLID | FRONT | DIPTH,		/* EY */
	VOWEL | VOICE | SYLLA | SONOR | LAX | HIGH | FRONT | DIPTH,	/* IH */
	VOWEL | VOICE | SYLLA | SONOR | SCHWA | LAX | HIGH | FRONT,	/* IX */
	VOWEL | VOICE | SYLLA | SONOR | RGLID | HIGH | FRONT | DIPTH,  /* IXR */
	VOWEL | VOICE | SYLLA | SONOR | YGLID | HIGH | FRONT | F2BAC | DIPTH, /* IY */
	VOWEL | VOICE | SYLLA | SONOR | WGLID | ROUND | DIPTH,		/* OW */
	VOWEL | VOICE | SYLLA | SONOR | ROUND | RGLID | DIPTH,	       /* OXR */
	VOWEL | VOICE | SYLLA | SONOR | YGLID | ROUND | DIPTH,		/* OY */
	VOWEL | VOICE | SYLLA | SONOR | LAX | DIPTH,			/* UH */
	VOWEL | VOICE | SYLLA | SONOR | WGLID | ROUND | HIGH | DIPTH,	/* UW */
	VOWEL | VOICE | SYLLA | SONOR | RGLID | HIGH,		       /* UXR */
	VOWEL | VOICE | SYLLA | SONOR | WGLID | ROUND | HIGH | FRONT | F2BAC | DIPTH, /* YU */
	VOICE | SYLLA | SONOR | LATER,					/* EL */
	SONOR | ASPSE,							/* HH */
	VOICE | SONOR | ASPSE,						/* HX */
	VOICE | SONOR | LIQGL | LATER,					/* LL */
	VOICE | SONOR | LIQGL | LATER,					/* LX */
	VOICE | SONOR | LIQGL | RETRO,					/* RR */
	VOICE | SONOR | LIQGL | RETRO,					/* RX */
	VOICE | SONOR | ROUND | LIQGL | HIGH | LABIA,			/* WW */
	VOICE | SONOR | ROUND | LIQGL | HIGH | LABIA | ASPSE,		/* WH */
	VOICE | SONOR | PALAT | LIQGL | HIGH | F2BAC,			/* YY */
	VOICE | SYLLA | STOP | SONOR | NASAL | LABIA,			/* EM */
	VOICE | SYLLA | STOP | SONOR | NASAL | ALVEO,			/* EN */
	VOICE | STOP | SONOR | NASAL | LABIA,				/* MM */
	VOICE | STOP | SONOR | NASAL | ALVEO,				/* NN */
	VOICE | STOP | SONOR | NASAL,					/* NG */
	VOICE | STOP | FRICA | ALVEO,					/* DH */
	LABIA | FRICA,							/* FF */
	FRICA | ALVEO,							/* SS */
	PALAT | FRICA,							/* SH */
	FRICA | DENTA,							/* TH */
	VOICE | LABIA | FRICA,						/* VV */
	VOICE | FRICA,							/* ZZ */
	VOICE | FRICA,							/* ZH */
	VOICE | STOP | LABIA | PLOSI,					/* BB */
	VOICE | STOP | PLOSI | ALVEO,					/* DD */
	VOICE | STOP | ALVEO,						/* DX */
	VOICE | STOP | VELAR | PLOSI,					/* GG */
	VOICE | STOP | PLOSI,						/* GP */
	STOP | VELAR | PLOSI,						/* KK */
	STOP | PLOSI | PALVE,						/* KP */
	STOP | PLOSI | LABIA,						/* PP */
	STOP | PLOSI | ALVEO,						/* TT */
	STOP | PLOSI | ALVEO,						/* TQ */
	STOP | PLOSI | PALAT | AFFRI,					/* CH */
	VOICE | STOP | PLOSI | PALAT | AFFRI,				/* JJ */
	LAX
};



/* f0 f1 f2 f3 bw1 bw2 bw3 fnz fnp av anp asp af a1 a2 a3 a4 a5 a6 ab */
frame_ty Vowels[23][2] =
{
	{
		/* AA */
		{0,700,1220,2600,130, 70,160,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,700,1220,2600,130, 70,160,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* AE */
		{0,620,1660,2430, 70,130,300,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,650,1490,2470, 70,100,320,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* AH */
		{0,620,1220,2550, 80, 50,140,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,620,1220,2550, 80, 50,140,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* AO */
		{0,600, 990,2570, 90,100, 80,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,630,1040,2600, 90,100, 80,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* AW */
		{0,640,1230,2550, 80, 70,140,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,420, 940,2350, 80, 70, 80,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* AX */
		{0,550,1260,2470, 80, 50,140,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,550,1260,2470, 80, 50,140,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* AXR */
		{0,680,1170,2380, 60, 60,110,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,520,1400,1650, 60, 60,110,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* AY */
		{0,660,1200,2550,100, 70,200,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,400,1880,2500, 70,100,200,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* EH */
		{0,530,1680,2500, 60, 90,200,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,620,1530,2530, 60, 90,200,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* ER */
		{0,470,1270,1540,100, 60,110,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,420,1310,1540,100, 60,110,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* EXR */
		{0,460,1650,2400, 60, 80,140,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,450,1500,1700, 60, 80,140,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* EY */
		{0,480,1720,2520, 70,100,200,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,330,2200,2600, 55,100,200,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* IH */
		{0,400,1800,2670, 50,100,140,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,470,1600,2600, 50,100,140,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* IX */
		{0,420,1680,2520, 50,100,140,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,420,1680,2520, 50,100,140,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* IXR */
		{0,320,1900,2900, 70, 80,120,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,420,1550,1750, 70, 80,120,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* IY */
		{0,310,2200,2960, 50,200,400,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,290,2070,2980, 60,200,400,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* OW */
		{0,540,1100,2300, 80, 70, 70,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,450, 900,2300, 80, 70, 70,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* OXR */
		{0,550, 820,2200, 60, 60, 60,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,490,1300,1500, 60, 60, 60,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* OY */
		{0,550, 960,2400, 80, 50,130,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,360,1820,2450, 60, 50,160,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* UH */
		{0,450,1100,2350, 80,100, 80,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,500,1180,2390, 80,100, 80,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* UW */
		{0,350,1250,2200, 65,110,140,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,320, 900,2200, 65,110,140,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* UXR */
		{0,360, 800,2000, 60, 60, 80,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,390,1150,1500, 60, 60, 80,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
	{
		/* YU */
		{0,290,1900,2600, 70,160,220,0,0,48,0,0,0,60,60,60,60,60,60,0},
		{0,330,1200,2100, 70,160,220,0,0,48,0,0,0,60,60,60,60,60,60,0},
	},
};

/* f0 f1 f2 f3 bw1 bw2 bw3 fnz fnp av anp asp af a1 a2 a3 a4 a5 a6 ab */
frame_ty Sonorants[10] =
{
	{0,450, 800,2850, 65, 60, 80,0,0,47,0, 0,0,0,0,0,0,0,0,0},/* EL */
	{0,450,1450,2450,300,160,300,0,0, 0,0,45,0,0,0,0,0,0,0,0},/* HH */
	{0,450,1450,2450,200,120,200,0,0,55,0,53,0,0,0,0,0,0,0,0},/* HX */
	{0,330,1050,2800, 50,100,280,0,0,51,0, 0,0,0,0,0,0,0,0,0},/* LL */
	{0,450, 800,2850, 65, 60, 80,0,0,51,0, 0,0,0,0,0,0,0,0,0},/* LX */
	{0,330,1060,1380, 70,100,120,0,0,51,0, 0,0,0,0,0,0,0,0,0},/* RR */
	{0,460,1260,1560, 60, 60, 70,0,0,53,0, 0,0,0,0,0,0,0,0,0},/* RX */
	{0,285, 610,2150, 50, 80, 60,0,0,53,0, 0,0,0,0,0,0,0,0,0},/* WW */
	{0,330, 600,2100,150, 60, 60,0,0, 0,0,51,0,0,0,0,0,0,0,0},/* WH */
	{0,240,2070,3020, 40,250,500,0,0,53,0, 0,0,0,0,0,0,0,0,0},/* YY */
};

/* doesthe datain the fnz and fnp columns need to be swapped? */
/* f0 f1 f2 f3 bw1 bw2 bw3 fnz fnp av anp asp af a1 a2 a3 a4 a5 a6 ab */
frame_ty Nasals[5] =
{
	{0,200, 900,2100,120, 60, 70,450,270,55,0,0,0,0,0,0,0,0,0,0},/* EM */
	{0,200,1600,2700,120, 70,110,450,270,55,0,0,0,0,0,0,0,0,0,0},/* EN */
	{0,480,1270,2130, 40,200,200,450,270,55,0,0,0,0,0,0,0,0,0,0},/* MM */
	{0,480,1340,2470, 40,300,300,450,270,55,0,0,0,0,0,0,0,0,0,0},/* NN */
	{0,480,1600,2050,160,150,100,450,270,51,0,0,0,0,0,0,0,0,0,0},/* NG */
};

/* f0 f1 f2 f3 bw1 bw2 bw3 fnz fnp av anp asp af a1 a2 a3 a4 a5 a6 ab */
frame_ty Fricatives[8] =
{
	{0,300,1150,2700, 60, 95,185,0,0,47,0, 0,50,0,0, 0, 0, 0,30,54},/* DH */
	{0,400,1130,2100,225,120,175,0,0, 0,0,31,60,0,0, 0, 0, 0, 0,64},/* FF */
	{0,400,1400,2700,200, 95,220,0,0, 0,0,10,40,0,0, 0, 0,50,82, 0},/* SS */
	{0,400,1650,2400,200,110,280,0,0, 0,0,31,45,0,0,60,75,70,70, 0},/* SH */
	{0,320,1290,2540,200, 90,200,0,0, 0,0,41,60,0,0, 0, 0, 0,30,54},/* TH */
	{0,300,1130,2100, 55, 95,125,0,0,60,0, 0,60,0,0, 0, 0, 0, 0,64},/* VV */
	{0,240,1390,2530, 70, 60,180,0,0,60,0, 0,50,0,0, 0, 0, 0,52, 0},/* ZZ */
	{0,300,1840,2750,200,100,300,0,0,60,0, 0,50,0,0,57,48,48,46, 0}	/* ZH */
};


/* f0 f1 f2 f3 bw1 bw2 bw3 fnz fnp av anp asp af a1 a2 a3 a4 a5 a6 ab */
frame_ty Plosives[10] =
{
	{0,200, 900,2100, 65, 90,125,0,0,70,0,0, 0,0, 0, 0, 0,50,72, 0},/* BB */
	{0,200,1600,2600, 60,100,170,0,0,65,0,0,50,0, 0,47,60,62,60, 0},/* DD */
	{0,200,1600,2700,120,140,250,0,0,44,0,0, 0,0,60,60,60,60,60, 0},/* DX */
	{0,270,1400,1900, 70,145,190,0,0,60,0,0,50,0,60,45,40, 0, 0, 0},/* GG */
	{0,200,1950,2800,120,140,250,0,0,60,0,0, 0,0,30,70,60,62,62, 0},/* GP */
	{0,350,1600,1900,280,220,250,0,0, 0,0,0, 0,0,70,30,30,60,10, 0},/* KK */
	{0,300,1950,2800,150,140,250,0,0, 0,0,0, 0,0,30,70,60,62,62, 0},/* KP */
	{0,300, 900,2100,300,190,185,0,0, 0,0,0, 0,0, 0, 0, 0, 0, 0,72},/* PP */
	{0,300,1400,2700,300,180,220,0,0, 0,0,0, 0,0, 0, 0, 0,50,82, 0},/* TT */
	{0,200,1400,2700,120,140,250,0,0, 0,0,0, 0,0, 0, 0, 0,50,82, 0},/* TQ */
};

/* f0 f1 f2 f3 bw1 bw2 bw3 fnz fnp av anp asp af a1 a2 a3 a4 a5 a6 ab */
frame_ty Affricates[2] =
{
	{0,300,1700,2400,200,110,270,0,0,0,0,0,0,0,0,60,75,70,70,0},/* CH */
	{0,200,1700,2400, 50,110,270,0,0,0,0,0,0,0,0,60,75,70,70,0},/* JJ */
};

/* f0 f1 f2 f3 bw1 bw2 bw3 fnz fnp av anp asp af a1 a2 a3 a4 a5 a6 ab */
frame_ty Psuedo_vowels[1] =
{
	{0,430,1500,2500,120,60,120,0,0,57,0,0,0,0,60,60,60,60,60,0},/* AXP */
};


char *
phonemes_type_name(n)
	int	n;
{
	static char name[8];

	switch (n)
	{
	case VOWEL_TYPE:
		return "vowel";

	case SONORANT_TYPE:
		return "sonorant";

	case NASAL_TYPE:
		return "nasal";

	case FRICATIVE_TYPE:
		return "fricative";

	case PLOSIVE_TYPE:
		return "plosive";

	case AFFRICATE_TYPE:
		return "affricate";

	case PSUEDO_VOWEL_TYPE:
		return "psuedo_vowel";
	}
	sprintf(name, "%d", n);
	return name;
}


char *
phonemes_name(n)
	int	n;
{
	static char name[8];

	switch (n)
	{
	case AA:	return "AA";
	case AE:	return "AE";
	case AH:	return "AH";
	case AO:	return "AO";
	case AW:	return "AW";
	case AX:	return "AX";
	case AXR:	return "AXR";
	case AY:	return "AY";
	case EH:	return "EH";
	case ER:	return "ER";
	case EXR:	return "EXR";
	case EY:	return "EY";
	case IH:	return "IH";
	case IX:	return "IX";
	case IXR:	return "IXR";
	case IY:	return "IY";
	case OW:	return "OW";
	case OXR:	return "OXR";
	case OY:	return "OY";
	case UH:	return "UH";
	case UW:	return "UW";
	case UXR:	return "UXR";
	case YU:	return "YU";
	case EL:	return "EL";
	case HH:	return "HH";
	case HX:	return "HX";
	case LL:	return "LL";
	case LX:	return "LX";
	case RR:	return "RR";
	case RX:	return "RX";
	case WW:	return "WW";
	case WH:	return "WH";
	case YY:	return "YY";
	case EM:	return "EM";
	case EN:	return "EN";
	case MM:	return "MM";
	case NN:	return "NN";
	case NG:	return "NG";
	case DH:	return "DH";
	case FF:	return "FF";
	case SS:	return "SS";
	case SH:	return "SH";
	case TH:	return "TH";
	case VV:	return "VV";
	case ZZ:	return "ZZ";
	case ZH:	return "ZH";
	case BB:	return "BB";
	case DD:	return "DD";
	case DX:	return "DX";
	case GG:	return "GG";
	case GP:	return "GP";
	case KK:	return "KK";
	case KP:	return "KP";
	case PP:	return "PP";
	case TT:	return "TT";
	case TQ:	return "TQ";
	case CH:	return "CH";
	case JJ:	return "JJ";
	case AXP:	return "AXP";
	case WORD_BREAK: return "WORD_BREAK";
	}
	sprintf(name, "%d", n);
	return name;
}
