#! /bin/sh

# Test representation of a table with URLs

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pl)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

# Set up the testing "sandbox":
SRC_DB_DIR=db
TMP_DB_DIR=${TMP_DIR}/db
mkdir ${TMP_DB_DIR}

TMP_TEST_DB=samples.db
TMP_DB_FILE=${TMP_DB_DIR}/samples.db
TMP_DB_META=${TMP_DB_DIR}/restful.db
TMP_DB_FILE_ABS=$(cd $(dirname ${TMP_DB_FILE}); pwd)/${TMP_TEST_DB}

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin
mkdir ${TMP_DIR}/tests

cp ${INPUT_SCRIPT} ${TMP_DIR}/website/cgi-bin

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tests/inputs ${TMP_DIR}/tests

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

sqlite3 ${TMP_DB_FILE} < tests/inputs/samples-r92.sql
sqlite3 ${TMP_DB_FILE} <<END
    insert into lithology_img (id, uuid, revision_id, caption, image, format)
        values (1, 'aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaaa', 1,
                '13eb0294df925c96666aa0c746d4d76a',
                '{"data":[]}', 'json');
END

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} < tests/inputs/samples-metadata-r92.sql
sqlite3 ${TMP_DB_META} <<END
    insert into description (id, dbtable, dbcolumn, coltype, fk_target)
        values (140, 'lithology_img', 'caption', 'md5', 122);
END
sqlite3 ${TMP_DB_META} "update description set dbname = '${TMP_DB_FILE_ABS}'"

export REQUEST_URI='/~saulius/restful/website/samples.db/lithology_img'
export HTTP_HOST=test.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE="multipart/form-data; boundary=------------------------b989696a28305e74"
export REMOTE_USER=writer

perl -lne 'print "$_\r"' <<EOF |
--------------------------b989696a28305e74
Content-Disposition: form-data; name="jsonfile"; filename="upload.json"
Content-Type: text/plain

{
    "data": [
        {
            "attributes" : {
                "image" : {
                    "data" : [
                        { "id" : 1, "description" : "first item" },
                        { "id" : 2, "description" : "second item" }
                    ]
                },
                "format" : "json",
                "uuid" : "aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaaa"
            },
            "type" : "lithology_img"
        }
    ]
}
--------------------------b989696a28305e74--
EOF
${INPUT_SCRIPT}

# Different versions of MIME detecting modules treat JSON either as
# 'model/x.stl-binary' (old versions) or 'text/plain' (newer).

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from lithology_img' \
    | sed 's/model\/x\.stl-binary/text\/plain/'

# Go back to the original directory before deleting the temporary one:
cd - > /dev/null

# Temporary directory will be deleted by the trap.
