#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "p_laplacian_circle.icc"
int main(int argc, char**argv) {
  environment rheolef (argc,argv);
  Float tol = (argc > 1) ? atof(argv[1]) : 1e-15;
  Float p;
  field uh;
  din >> catchmark("p") >> p
      >> catchmark("u") >> uh;
  const geo& omega = uh.get_geo();
  const space& Xh = uh.get_space();
  field pi_h_u = interpolate (Xh, u_exact(p));
  field eh = pi_h_u - uh;
  quadrature_option_type qopt;
  qopt.set_family(quadrature_option_type::gauss);
  qopt.set_order(2*Xh.degree());
  Float err_lp  = pow(integrate (omega,
    pow(fabs(uh - u_exact(p)), p), qopt), 1./p);
  Float err_w1p = pow(integrate (omega,
    pow(norm(grad(uh) - grad_u(p)), p), qopt), 1./p);
  Float err_linf = eh.max_abs();
  dout << "err_linf = " << err_linf << endl
       << "err_lp   = " << err_lp << endl
       << "err_w1p  = " << err_w1p << endl;
  return (err_linf < tol) ? 0 : 1;
}
