# Contributing to Jami Gnome

GNU Jami welcomes contribution from everyone. Here are some ideas if you want
to help:

## Packaging

Packaging Jami allows easier installation by end-users and in this sense it's an
excellent way of contributing to Jami!

If your distribution doesn't have a Jami package you can create one, and if
somebody is already maintaining a Jami package for your distribution,
you can help him out!

## Design

Jami aims to be a universal platform of communication, accessible and usable by
everybody. If you find issues with the client, or simply want to suggest
improvement ideas, the bug tracker is the perfect place to submit them.

## Documentation

The documentation should be as up-to-date as possible to help users, devs and
anyone who wants to get informations. This wiki is currently located [here](https://git.jami.net/savoirfairelinux/ring-project/wikis/home).

## Testing

The client is under continuous development with new features, bugfixes, etc.
Because communications software depends on a lot of conditions, we need people
to test and fill tickets when necessary. To submit a new bug, go to https://git.jami.net/savoirfairelinux/ring-client-gnome/issues.

Sometimes interpreting bug reports is difficult for us, for example because we
can't reproduce the bug or understand what exactly the issue is.
This is usually because the bug report lacks of details / is too vague.

In order to make your bug report as helpful as possible, think about providing
as many details, clear explanations and scenarios as possible!
Also, we've written a [guide on how to report bugs](https://git.jami.net/savoirfairelinux/ring-project/wikis/Bug-report-guide),
if you're unsure, check it out! 

## Support

Helping users when they post issues or questions on a social network or IRC for example is appreciated. Thank you!

## Communication

Talk to Jami to other people is appreciated too!

## Translation

We are currently using [Transifex](https://www.transifex.com/savoirfairelinux/ring/) to translate the client.

## Development

Finally and not the least, you can also try to develop new features for this client.
The best way is to communicate with current developers via the Contact section (see below)
or by filling a new issue [here](https://git.jami.net/savoirfairelinux/ring-client-gnome/issues)
or by taking one. See the [`good-first-bug` label](https://git.jami.net/savoirfairelinux/ring-client-gnome/issues?label_name%5B%5D=good+first+bug)
if you don't know where to start.

# Contact

contributors and users frequent:
+ the `#ring` channel on `irc.freenode.net`
+ the mailing list: `ring@gnu.org`
