/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.TypeCast;
import java.io.IOException;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public class MBeanServerConnection_Hook
implements MBeanServerConnection {
    private final MBeanServerConnection mConn;
    public static final String CREATE_MBEAN = "createMBean";
    public static final String UNREGISTER_MBEAN = "unregisterMBean";
    public static final String REGISTER_MBEAN = "registerMBean";
    public static final String GET_OBJECT_INSTANCE = "getObjectInstance";
    public static final String QUERY_MBEANS = "queryMBeans";
    public static final String QUERY_NAMES = "queryNames";
    public static final String GET_DOMAINS = "getDomains";
    public static final String IS_REGISTERED = "isRegistered";
    public static final String GET_MBEAN_COUNT = "getMBeanCount";
    public static final String GET_ATTRIBUTE = "getAttribute";
    public static final String GET_ATTRIBUTES = "getAttributes";
    public static final String SET_ATTRIBUTE = "setAttribute";
    public static final String SET_ATTRIBUTES = "setAttributes";
    public static final String INVOKE = "invoke";
    public static final String GET_DEFAULT_DOMAIN = "getDefaultDomain";
    public static final String ADD_NOTIFICATION_LISTENER = "addNotificationListener";
    public static final String REMOVE_NOTIFICATION_LISTENER = "removeNotificationListener";
    public static final String GET_MBEAN_INFO = "getMBeanInfo";
    public static final String IS_INSTANCE_OF = "isInstanceOf";

    Hook getHook() {
        return HookImpl.HOOK;
    }

    public MBeanServerConnection_Hook(MBeanServerConnection conn) {
        this.mConn = conn;
        assert (this.getConn() != null);
    }

    MBeanServerConnection getConn() {
        return this.mConn;
    }

    void callIOExceptionHook(long id, IOException e, String operationName, ObjectName objectName, Object[] allArgs) throws IOException {
        this.getHook().IOExceptionHook(id, e, operationName, objectName, allArgs);
    }

    long callPreHook(String name, Object[] args) {
        return this.getHook().preHook(name, args);
    }

    long callPreHook(String name) {
        return this.getHook().preHook(name);
    }

    void callPostHook(long id, String name, Object[] args, Object result) {
        this.getHook().postHook(id, name, args, result);
    }

    void callPostHook(long id, String name, Object[] args) {
        this.getHook().postHook(id, name, args);
    }

    void callPostHook(long id, String name) {
        this.getHook().postHook(id, name);
    }

    ObjectName callNameHook(long id, ObjectName objectName) throws IOException {
        return this.getHook().nameHook(id, objectName);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        Object[] args = new Object[]{className, name};
        long id = this.callPreHook(CREATE_MBEAN, args);
        ObjectInstance result = null;
        try {
            result = this.getConn().createMBean(className, name);
            this.callPostHook(id, CREATE_MBEAN, args, result);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, CREATE_MBEAN, name, args);
        }
        return result;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        Object[] args = new Object[]{className, name, loaderName};
        long id = this.callPreHook(CREATE_MBEAN, args);
        ObjectInstance result = null;
        try {
            result = this.getConn().createMBean(className, name, loaderName);
            this.callPostHook(id, CREATE_MBEAN, args, result);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, CREATE_MBEAN, name, args);
        }
        catch (InstanceNotFoundException e) {
            this.getHook().InstanceNotFoundExceptionHook(CREATE_MBEAN, id, e);
        }
        return result;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        Object[] args = new Object[]{className, name, params, signature};
        long id = this.callPreHook(CREATE_MBEAN, args);
        ObjectInstance result = null;
        try {
            result = this.getConn().createMBean(className, name, params, signature);
            this.callPostHook(id, CREATE_MBEAN, args, result);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, CREATE_MBEAN, name, args);
        }
        return result;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        Object[] args = new Object[]{className, name, loaderName, params, signature};
        long id = this.callPreHook(CREATE_MBEAN, args);
        ObjectInstance result = null;
        try {
            result = this.getConn().createMBean(className, name, loaderName, params, signature);
            this.callPostHook(id, CREATE_MBEAN, args, result);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, CREATE_MBEAN, name, args);
        }
        catch (InstanceNotFoundException e) {
            this.getHook().InstanceNotFoundExceptionHook(CREATE_MBEAN, id, e);
        }
        return result;
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        Object[] args = new Object[]{name};
        long id = this.callPreHook(UNREGISTER_MBEAN, args);
        try {
            this.getConn().unregisterMBean(this.callNameHook(id, name));
            this.callPostHook(id, UNREGISTER_MBEAN, args);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, UNREGISTER_MBEAN, name, args);
        }
        catch (InstanceNotFoundException e) {
            this.getHook().InstanceNotFoundExceptionHook(UNREGISTER_MBEAN, id, e);
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        Object[] args = new Object[]{name};
        long id = this.callPreHook(GET_OBJECT_INSTANCE, args);
        ObjectInstance result = null;
        try {
            result = this.getConn().getObjectInstance(this.callNameHook(id, name));
            this.callPostHook(id, GET_OBJECT_INSTANCE, args, result);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, GET_OBJECT_INSTANCE, name, args);
        }
        catch (InstanceNotFoundException e) {
            this.getHook().InstanceNotFoundExceptionHook(GET_OBJECT_INSTANCE, id, e);
        }
        return result;
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
        Object[] args = new Object[]{name, query};
        long id = this.callPreHook(QUERY_MBEANS, args);
        Set<ObjectInstance> result = null;
        try {
            result = TypeCast.asSet(this.getConn().queryMBeans(name, query));
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, QUERY_MBEANS, name, args);
        }
        this.callPostHook(id, QUERY_MBEANS, args, result);
        return result;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
        Object[] args = new Object[]{name, query};
        long id = this.callPreHook(QUERY_NAMES, args);
        Set<ObjectName> result = null;
        try {
            result = JMXUtil.queryNames(this.getConn(), name, query);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, QUERY_NAMES, name, args);
        }
        this.callPostHook(id, QUERY_NAMES, args, result);
        return result;
    }

    @Override
    public boolean isRegistered(ObjectName name) throws IOException {
        Object[] args = new Object[]{name};
        long id = this.callPreHook(IS_REGISTERED, args);
        boolean registered = false;
        try {
            registered = this.getConn().isRegistered(this.callNameHook(id, name));
            this.callPostHook(id, IS_REGISTERED, args, registered ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, IS_REGISTERED, name, args);
        }
        return registered;
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        long id = this.callPreHook(GET_MBEAN_COUNT, null);
        Integer result = null;
        try {
            result = this.getConn().getMBeanCount();
            this.callPostHook(id, GET_MBEAN_COUNT, null, result);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, GET_MBEAN_COUNT, null, null);
        }
        return result;
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        Object[] args = new Object[]{name, attribute};
        long id = this.callPreHook(GET_ATTRIBUTE, args);
        Object result = null;
        try {
            result = this.getConn().getAttribute(this.callNameHook(id, name), attribute);
            this.callPostHook(id, GET_ATTRIBUTE, args, result);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, GET_ATTRIBUTE, name, args);
        }
        return result;
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        Object[] args = new Object[]{name, attributes};
        long id = this.callPreHook(GET_ATTRIBUTES, args);
        AttributeList result = null;
        try {
            ObjectName actualName = this.callNameHook(id, name);
            result = this.getConn().getAttributes(actualName, attributes);
            this.callPostHook(id, GET_ATTRIBUTES, args, result);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, GET_ATTRIBUTES, name, args);
        }
        return result;
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        Object[] args = new Object[]{name, attribute};
        long id = this.callPreHook(SET_ATTRIBUTE, args);
        try {
            this.getConn().setAttribute(this.callNameHook(id, name), attribute);
            this.callPostHook(id, SET_ATTRIBUTE, args);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, SET_ATTRIBUTE, name, args);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        Object[] args = new Object[]{name, attributes};
        long id = this.callPreHook(SET_ATTRIBUTES, args);
        AttributeList result = null;
        try {
            result = this.getConn().setAttributes(this.callNameHook(id, name), attributes);
            this.callPostHook(id, SET_ATTRIBUTES, args);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, SET_ATTRIBUTES, name, args);
        }
        return result;
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object[] args = new Object[]{name, operationName, params, signature};
        long id = this.callPreHook(INVOKE, args);
        Object result = null;
        try {
            result = this.getConn().invoke(this.callNameHook(id, name), operationName, params, signature);
            this.callPostHook(id, INVOKE, args);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, INVOKE, name, args);
        }
        return result;
    }

    @Override
    public String getDefaultDomain() throws IOException {
        long id = this.callPreHook(GET_DEFAULT_DOMAIN);
        String result = null;
        try {
            result = this.getConn().getDefaultDomain();
            this.callPostHook(id, GET_DEFAULT_DOMAIN);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, GET_DEFAULT_DOMAIN, null, null);
        }
        return result;
    }

    @Override
    public String[] getDomains() throws IOException {
        long id = this.callPreHook(GET_DOMAINS);
        Object[] result = null;
        try {
            result = this.getConn().getDomains();
            this.callPostHook(id, GET_DOMAINS, result);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, GET_DOMAINS, null, null);
        }
        return result;
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        Object[] args = new Object[]{name, listener, filter, handback};
        long id = this.callPreHook(ADD_NOTIFICATION_LISTENER, args);
        try {
            this.getConn().addNotificationListener(this.callNameHook(id, name), listener, filter, handback);
            this.callPostHook(id, ADD_NOTIFICATION_LISTENER, args);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, ADD_NOTIFICATION_LISTENER, name, args);
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        Object[] args = new Object[]{name, listener, filter, handback};
        long id = this.callPreHook(ADD_NOTIFICATION_LISTENER, args);
        try {
            this.getConn().addNotificationListener(this.callNameHook(id, name), listener, filter, handback);
            this.callPostHook(id, ADD_NOTIFICATION_LISTENER, args);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, ADD_NOTIFICATION_LISTENER, name, args);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Object[] args = new Object[]{listener};
        long id = this.callPreHook(REMOVE_NOTIFICATION_LISTENER, args);
        try {
            this.getConn().removeNotificationListener(this.callNameHook(id, name), listener);
            this.callPostHook(id, REMOVE_NOTIFICATION_LISTENER, args);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, REMOVE_NOTIFICATION_LISTENER, name, args);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Object[] args = new Object[]{name, listener, filter, handback};
        long id = this.callPreHook(REMOVE_NOTIFICATION_LISTENER, args);
        try {
            this.getConn().removeNotificationListener(this.callNameHook(id, name), listener, filter, handback);
            this.callPostHook(id, REMOVE_NOTIFICATION_LISTENER, args);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, REMOVE_NOTIFICATION_LISTENER, name, args);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Object[] args = new Object[]{name, listener};
        long id = this.callPreHook(REMOVE_NOTIFICATION_LISTENER, args);
        try {
            this.getConn().removeNotificationListener(this.callNameHook(id, name), listener);
            this.callPostHook(id, REMOVE_NOTIFICATION_LISTENER, args);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, REMOVE_NOTIFICATION_LISTENER, name, args);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Object[] args = new Object[]{name, listener, filter, handback};
        long id = this.callPreHook(REMOVE_NOTIFICATION_LISTENER, args);
        try {
            this.getConn().removeNotificationListener(this.callNameHook(id, name), listener, filter, handback);
            this.callPostHook(id, REMOVE_NOTIFICATION_LISTENER, args);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, REMOVE_NOTIFICATION_LISTENER, name, args);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        Object[] args = new Object[]{name};
        long id = this.callPreHook(GET_MBEAN_INFO, args);
        MBeanInfo result = null;
        try {
            result = this.getConn().getMBeanInfo(this.callNameHook(id, name));
            this.callPostHook(id, GET_MBEAN_INFO, args);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, GET_MBEAN_INFO, name, args);
        }
        return result;
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        Object[] args = new Object[]{name, className};
        long id = this.callPreHook(IS_INSTANCE_OF, args);
        boolean isInstance = false;
        try {
            isInstance = this.getConn().isInstanceOf(this.callNameHook(id, name), className);
            this.callPostHook(id, IS_INSTANCE_OF, args, isInstance ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (IOException e) {
            this.callIOExceptionHook(id, e, IS_INSTANCE_OF, name, args);
        }
        return isInstance;
    }

    public static class HookImpl
    implements Hook {
        public static final HookImpl HOOK = new HookImpl();
        long mID = 0L;

        synchronized long getNewID() {
            return this.mID++;
        }

        @Override
        public long preHook(String methodName) {
            return this.getNewID();
        }

        @Override
        public long preHook(String methodName, Object[] args) {
            return this.getNewID();
        }

        @Override
        public void postHook(long id, String methodName) {
        }

        @Override
        public void postHook(long id, String methodName, Object[] args) {
        }

        @Override
        public void postHook(long id, String methodName, Object[] args, Object result) {
        }

        @Override
        public ObjectName nameHook(long id, ObjectName methodName) throws IOException {
            return methodName;
        }

        @Override
        public void IOExceptionHook(long id, IOException e, String operationName, ObjectName objectName, Object[] allArgs) throws IOException {
            throw e;
        }

        @Override
        public void InstanceNotFoundExceptionHook(String methodName, long id, InstanceNotFoundException e) throws InstanceNotFoundException {
            throw e;
        }

        String getInvocationString(String methodName, Object[] args) {
            assert (methodName != null);
            String msg = methodName + "(";
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    String s = "";
                    s = arg == null ? "null" : (arg instanceof String || arg instanceof ObjectName ? "\"" + arg + "\"" : arg.toString());
                    msg = msg + s;
                    if (i == args.length - 1) continue;
                    msg = msg + ",";
                }
            }
            msg = msg + ")";
            return msg;
        }

        String getInvocationString(long id, String methodName, Object[] args) {
            return "" + id + this.getInvocationString(methodName, args);
        }
    }

    public static interface Hook {
        public long preHook(String var1);

        public long preHook(String var1, Object[] var2);

        public void postHook(long var1, String var3);

        public void postHook(long var1, String var3, Object[] var4);

        public void postHook(long var1, String var3, Object[] var4, Object var5);

        public ObjectName nameHook(long var1, ObjectName var3) throws IOException;

        public void IOExceptionHook(long var1, IOException var3, String var4, ObjectName var5, Object[] var6) throws IOException;

        public void InstanceNotFoundExceptionHook(String var1, long var2, InstanceNotFoundException var4) throws InstanceNotFoundException;
    }
}

